/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table;

import com.aliyun.odps.table.utils.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class StreamIdentifier
implements Serializable {
    private final String project;
    private final String streamName;

    public static StreamIdentifier of(String project, String streamName) {
        return new StreamIdentifier(project, streamName);
    }

    public StreamIdentifier(String project, String streamName) {
        Preconditions.checkString(project, "Identifier project cannot be null");
        Preconditions.checkString(streamName, "Identifier streamName cannot be null");
        this.project = project;
        this.streamName = streamName;
    }

    public String getProject() {
        return this.project;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String toString() {
        return String.join((CharSequence)".", this.project, this.streamName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamIdentifier that = (StreamIdentifier)o;
        return this.project.equals(that.project) && this.streamName.equals(that.streamName);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.streamName);
    }
}

