/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ShowPartitionsCommand
implements Command {
    private String project;
    private String schema;
    private String table;
    private String partition;

    public ShowPartitionsCommand(String project, String schema, String table, String partition) {
        this.project = project;
        this.schema = schema;
        this.table = table;
        this.partition = partition;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return Collections.singletonList(TypeInfoFactory.STRING);
    }

    @Override
    public List<String> getResultHeaders() {
        return Collections.singletonList("PartitionSpec");
    }

    @Override
    public RecordIter run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        boolean useOdpsNamespaceSchema = commandInfo.isOdpsNamespaceSchema();
        String schemaCopy = this.schema;
        this.schema = CommandUtil.getRealSchemaName(odps, this.project, this.schema, useOdpsNamespaceSchema);
        this.project = CommandUtil.getRealProjectName(odps, this.project, schemaCopy, useOdpsNamespaceSchema);
        Table t = odps.tables().get(this.project, this.schema, this.table);
        Iterator<Partition> parts = this.partition != null ? t.getPartitionIterator(new PartitionSpec(this.partition)) : t.getPartitionIterator();
        return new PartitionRecordIter(parts, this.getResultHeaders(), this.getResultTypes());
    }

    static class PartitionRecordIter
    extends RecordIter<Partition> {
        PartitionRecordIter(Iterator<Partition> partitionIterator, List<String> headers, List<TypeInfo> typeInfos) {
            super(partitionIterator, headers, typeInfos);
        }

        @Override
        Record toRecord(Partition partition) {
            String p = partition.getPartitionSpec().toString();
            p = p.replaceAll("'", "");
            p = p.replaceAll(",", "/");
            ArrayRecord record = new ArrayRecord(this.columns);
            record.set(0, (Object)p);
            return record;
        }
    }
}

