/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SessionRecordSetIterator
implements Iterator<Record> {
    private List<Record> buffer;
    private static final long FETCH_SIZE = 10000L;
    private long cursor = 0L;
    private int idx = 0;
    private long fetchSize = 0L;
    private long recordCount;
    private long offset;
    private long sizeLimit;
    private long currentReadSize = 0L;
    private InstanceTunnel.DownloadSession session;
    private TunnelRecordReader reader;

    public SessionRecordSetIterator(InstanceTunnel.DownloadSession session, TunnelRecordReader reader, long recordCount, long offset, long sizeLimit) {
        this.session = session;
        this.reader = reader;
        this.recordCount = recordCount;
        this.offset = offset;
        this.sizeLimit = sizeLimit;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.recordCount;
    }

    @Override
    public Record next() {
        if (this.buffer == null || this.idx == this.buffer.size()) {
            this.fillBuffer();
        }
        ++this.cursor;
        return this.buffer.get(this.idx++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private void fillBuffer() {
        this.idx = 0;
        if (this.cursor != 0L || this.recordCount > 10000L) {
            this.reader = this.openNewReader();
        }
        this.buffer = new ArrayList<Record>();
        Record r = null;
        try {
            while ((r = this.reader.read()) != null) {
                this.buffer.add(r);
                if (this.sizeLimit <= 0L || this.currentReadSize + this.reader.getTotalBytes() <= this.sizeLimit) continue;
                throw new RuntimeException("InvalidArgument: sizeLimit, fetched data is larger than limit size");
            }
            this.currentReadSize += this.reader.getTotalBytes();
        }
        catch (IOException e) {
            throw new RuntimeException("Read from reader failed:", e);
        }
    }

    private TunnelRecordReader openNewReader() {
        this.fetchSize = this.recordCount - this.cursor <= 10000L ? this.recordCount - this.cursor : 10000L;
        try {
            return this.session.openRecordReader(this.cursor + this.offset, this.fetchSize);
        }
        catch (TunnelException e) {
            throw new RuntimeException("Open reader failed: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Open reader failed: " + e.getMessage(), e);
        }
    }
}

