/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.DefaultType;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementArray;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.ElementListUnion;
import com.aliyun.odps.simpleframework.xml.ElementMap;
import com.aliyun.odps.simpleframework.xml.ElementMapUnion;
import com.aliyun.odps.simpleframework.xml.ElementUnion;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.Transient;
import com.aliyun.odps.simpleframework.xml.Version;
import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.ContactList;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.MethodContact;
import com.aliyun.odps.simpleframework.xml.core.MethodDetail;
import com.aliyun.odps.simpleframework.xml.core.MethodException;
import com.aliyun.odps.simpleframework.xml.core.MethodPart;
import com.aliyun.odps.simpleframework.xml.core.MethodPartFactory;
import com.aliyun.odps.simpleframework.xml.core.MethodType;
import com.aliyun.odps.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

class MethodScanner
extends ContactList {
    private final MethodPartFactory factory;
    private final Support support;
    private final PartMap write;
    private final PartMap read;
    private final Detail detail;

    public MethodScanner(Detail detail, Support support) throws Exception {
        this.factory = new MethodPartFactory(detail, support);
        this.write = new PartMap();
        this.read = new PartMap();
        this.support = support;
        this.detail = detail;
        this.scan(detail);
    }

    private void scan(Detail detail) throws Exception {
        DefaultType override = detail.getOverride();
        DefaultType access = detail.getAccess();
        Class base = detail.getSuper();
        if (base != null) {
            this.extend(base, override);
        }
        this.extract(detail, access);
        this.extract(detail);
        this.build();
        this.validate();
    }

    private void extend(Class base, DefaultType access) throws Exception {
        ContactList list = this.support.getMethods(base, access);
        for (Contact contact : list) {
            this.process((MethodContact)contact);
        }
    }

    private void extract(Detail detail) throws Exception {
        List<MethodDetail> methods = detail.getMethods();
        for (MethodDetail entry : methods) {
            Annotation[] list = entry.getAnnotations();
            Method method = entry.getMethod();
            for (Annotation label : list) {
                this.scan(method, label, list);
            }
        }
    }

    private void extract(Detail detail, DefaultType access) throws Exception {
        List<MethodDetail> methods = detail.getMethods();
        if (access == DefaultType.PROPERTY) {
            for (MethodDetail entry : methods) {
                Annotation[] list = entry.getAnnotations();
                Method method = entry.getMethod();
                Class value = this.factory.getType(method);
                if (value == null) continue;
                this.process(method, list);
            }
        }
    }

    private void scan(Method method, Annotation label, Annotation[] list) throws Exception {
        if (label instanceof Attribute) {
            this.process(method, label, list);
        }
        if (label instanceof ElementUnion) {
            this.process(method, label, list);
        }
        if (label instanceof ElementListUnion) {
            this.process(method, label, list);
        }
        if (label instanceof ElementMapUnion) {
            this.process(method, label, list);
        }
        if (label instanceof ElementList) {
            this.process(method, label, list);
        }
        if (label instanceof ElementArray) {
            this.process(method, label, list);
        }
        if (label instanceof ElementMap) {
            this.process(method, label, list);
        }
        if (label instanceof Element) {
            this.process(method, label, list);
        }
        if (label instanceof Version) {
            this.process(method, label, list);
        }
        if (label instanceof Text) {
            this.process(method, label, list);
        }
        if (label instanceof Transient) {
            this.remove(method, label, list);
        }
    }

    private void process(Method method, Annotation label, Annotation[] list) throws Exception {
        MethodPart part = this.factory.getInstance(method, label, list);
        MethodType type = part.getMethodType();
        if (type == MethodType.GET) {
            this.process(part, this.read);
        }
        if (type == MethodType.IS) {
            this.process(part, this.read);
        }
        if (type == MethodType.SET) {
            this.process(part, this.write);
        }
    }

    private void process(Method method, Annotation[] list) throws Exception {
        MethodPart part = this.factory.getInstance(method, list);
        MethodType type = part.getMethodType();
        if (type == MethodType.GET) {
            this.process(part, this.read);
        }
        if (type == MethodType.IS) {
            this.process(part, this.read);
        }
        if (type == MethodType.SET) {
            this.process(part, this.write);
        }
    }

    private void process(MethodPart method, PartMap map) {
        String name = method.getName();
        if (name != null) {
            map.put(name, method);
        }
    }

    private void process(MethodContact contact) {
        MethodPart get = contact.getRead();
        MethodPart set = contact.getWrite();
        if (set != null) {
            this.insert(set, this.write);
        }
        this.insert(get, this.read);
    }

    private void insert(MethodPart method, PartMap map) {
        String name = method.getName();
        MethodPart existing = (MethodPart)map.remove(name);
        if (existing != null && this.isText(method)) {
            method = existing;
        }
        map.put(name, method);
    }

    private boolean isText(MethodPart method) {
        Annotation label = method.getAnnotation();
        return label instanceof Text;
    }

    private void remove(Method method, Annotation label, Annotation[] list) throws Exception {
        MethodPart part = this.factory.getInstance(method, label, list);
        MethodType type = part.getMethodType();
        if (type == MethodType.GET) {
            this.remove(part, this.read);
        }
        if (type == MethodType.IS) {
            this.remove(part, this.read);
        }
        if (type == MethodType.SET) {
            this.remove(part, this.write);
        }
    }

    private void remove(MethodPart part, PartMap map) throws Exception {
        String name = part.getName();
        if (name != null) {
            map.remove(name);
        }
    }

    private void build() throws Exception {
        for (String name : this.read) {
            MethodPart part = (MethodPart)this.read.get(name);
            if (part == null) continue;
            this.build(part, name);
        }
    }

    private void build(MethodPart read, String name) throws Exception {
        MethodPart match = this.write.take(name);
        if (match != null) {
            this.build(read, match);
        } else {
            this.build(read);
        }
    }

    private void build(MethodPart read) throws Exception {
        this.add(new MethodContact(read));
    }

    private void build(MethodPart read, MethodPart write) throws Exception {
        Annotation label = read.getAnnotation();
        String name = read.getName();
        if (!write.getAnnotation().equals(label)) {
            throw new MethodException("Annotations do not match for '%s' in %s", name, this.detail);
        }
        Class type = read.getType();
        if (type != write.getType()) {
            throw new MethodException("Method types do not match for %s in %s", name, type);
        }
        this.add(new MethodContact(read, write));
    }

    private void validate() throws Exception {
        for (String name : this.write) {
            MethodPart part = (MethodPart)this.write.get(name);
            if (part == null) continue;
            this.validate(part, name);
        }
    }

    private void validate(MethodPart write, String name) throws Exception {
        MethodPart match = this.read.take(name);
        Method method = write.getMethod();
        if (match == null) {
            throw new MethodException("No matching get method for %s in %s", method, this.detail);
        }
    }

    private static class PartMap
    extends LinkedHashMap<String, MethodPart>
    implements Iterable<String> {
        private PartMap() {
        }

        @Override
        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        public MethodPart take(String name) {
            return (MethodPart)this.remove(name);
        }
    }
}

