/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.MethodException;
import com.aliyun.odps.simpleframework.xml.core.MethodPart;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class MethodContact
implements Contact {
    private Annotation label;
    private MethodPart set;
    private MethodPart get;
    private Class[] items;
    private Class owner;
    private Class item;
    private Class type;
    private String name;

    public MethodContact(MethodPart get) {
        this(get, null);
    }

    public MethodContact(MethodPart get, MethodPart set) {
        this.owner = get.getDeclaringClass();
        this.label = get.getAnnotation();
        this.items = get.getDependents();
        this.item = get.getDependent();
        this.type = get.getType();
        this.name = get.getName();
        this.set = set;
        this.get = get;
    }

    @Override
    public boolean isReadOnly() {
        return this.set == null;
    }

    public MethodPart getRead() {
        return this.get;
    }

    public MethodPart getWrite() {
        return this.set;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        T result = this.get.getAnnotation(type);
        if (type == this.label.annotationType()) {
            return (T)this.label;
        }
        if (result == null && this.set != null) {
            return this.set.getAnnotation(type);
        }
        return result;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Class getDependent() {
        return this.item;
    }

    @Override
    public Class[] getDependents() {
        return this.items;
    }

    @Override
    public Class getDeclaringClass() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void set(Object source, Object value) throws Exception {
        Method method = this.get.getMethod();
        Class<?> type = method.getDeclaringClass();
        if (this.set == null) {
            throw new MethodException("Property '%s' is read only in %s", this.name, type);
        }
        this.set.getMethod().invoke(source, value);
    }

    @Override
    public Object get(Object source) throws Exception {
        return this.get.getMethod().invoke(source, new Object[0]);
    }

    @Override
    public String toString() {
        return String.format("method '%s'", this.name);
    }
}

