/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.rest;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Survey;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AppAccount;
import com.aliyun.odps.account.AppStsAccount;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.commons.util.RetryExceedLimitException;
import com.aliyun.odps.commons.util.RetryStrategy;
import com.aliyun.odps.commons.util.SvnRevisionUtils;
import com.aliyun.odps.commons.util.backoff.BackOffStrategy;
import com.aliyun.odps.commons.util.backoff.FixedBackOffStrategy;
import com.aliyun.odps.rest.ErrorMessage;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestException;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class RestClient {
    private ThreadPoolExecutor deprecatedLogThreadPool = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    public static final int DEFAULT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_CONNECT_RETRYTIMES = 4;
    public static final int DEFAULT_READ_TIMEOUT = 120;
    public static final boolean DEFAULT_IGNORE_CERTS = false;
    public static final int DEFAULT_CHUNK_SIZE = 1496;
    private final Transport transport;
    private Account account;
    private AppAccount appAccount;
    private AppStsAccount appStsAccount;
    private String endpoint;
    private boolean ignoreCerts = false;
    private String defaultProject;
    private String currentSchema;
    private static final String USER_AGENT_PREFIX = "JavaSDK Revision:" + SvnRevisionUtils.getSvnRevision() + " Version:" + SvnRevisionUtils.getMavenVersion() + " JavaVersion:" + SvnRevisionUtils.getJavaVersion();
    private String userAgent;
    private Proxy proxy;
    private RetryLogger logger = null;
    private boolean deprecatedLoggerEnabled = true;
    private static final String CHARSET = "UTF-8";
    int connectTimeout = 10;
    int readTimeout = 120;
    int retryTimes = 4;
    int chunkSize = 1496;
    private Map<String, String> userDefinedHeaders = new HashMap<String, String>();

    public RetryLogger getRetryLogger() {
        return this.logger;
    }

    public void setRetryLogger(RetryLogger logger) {
        this.logger = logger;
    }

    @Survey
    public RestClient(Transport transport) {
        this.transport = transport;
    }

    public <T> T request(Class<T> clazz, String resource, String method) throws OdpsException {
        return this.request(clazz, resource, method, null, null, null);
    }

    public <T> T request(Class<T> clazz, String resource, String method, Map<String, String> params) throws OdpsException {
        return this.request(clazz, resource, method, params, null, null);
    }

    public <T> T stringRequest(Class<T> clazz, String resource, String method, Map<String, String> params, Map<String, String> headers, String body) throws OdpsException {
        try {
            return this.request(clazz, resource, method, params, headers, body.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public <T> T request(Class<T> clazz, String resource, String method, Map<String, String> params, Map<String, String> headers, byte[] body) throws OdpsException {
        T r = null;
        Response resp = this.request(resource, method, params, headers, body);
        try {
            r = SimpleXmlUtils.unmarshal(resp, clazz);
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + clazz.getName(), e);
        }
        return r;
    }

    public Response stringRequest(String resource, String method, Map<String, String> params, Map<String, String> headers, String body) throws OdpsException {
        try {
            return this.request(resource, method, params, headers, body.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Response request(String resource, String method, Map<String, String> params, Map<String, String> headers, byte[] body) throws OdpsException {
        if (null == body) {
            return this.request(resource, method, params, headers, null, 0L);
        }
        return this.request(resource, method, params, headers, new ByteArrayInputStream(body), body.length);
    }

    public Response request(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, long bodyLen) throws OdpsException {
        int retryTimes = 0;
        if (method.equalsIgnoreCase(Request.Method.GET.toString()) || method.equalsIgnoreCase(Request.Method.HEAD.toString())) {
            retryTimes = this.getRetryTimes();
            if (body != null && body.markSupported()) {
                body.mark(0);
            }
        }
        long retryWaitTime = this.getConnectTimeout() + this.getReadTimeout();
        FixedBackOffStrategy backOffStrategy = new FixedBackOffStrategy(retryWaitTime);
        RestRetryStrategy retryStrategy = new RestRetryStrategy(retryTimes, backOffStrategy);
        while (true) {
            backOffStrategy.setStartTime(System.currentTimeMillis());
            try {
                Response resp = this.requestWithNoRetry(resource, method, params, headers, body, bodyLen);
                if (resp == null) {
                    throw new OdpsException("Response is null.");
                }
                this.handleErrorResponse(resp);
                if (this.deprecatedLoggerEnabled) {
                    this.uploadDeprecatedLog();
                }
                return resp;
            }
            catch (OdpsException e) {
                try {
                    retryStrategy.onFailure(e, this.logger);
                }
                catch (RetryExceedLimitException ignore) {
                    throw e;
                }
                catch (InterruptedException ignore) {
                    throw e;
                }
                this.resetBody(body);
                continue;
            }
            break;
        }
    }

    private void uploadDeprecatedLog() {
        if (this.deprecatedLogThreadPool.getQueue().size() > 1000) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                ConcurrentHashMap deprecatedMaps = OdpsDeprecatedLogger.getDeprecatedCalls();
                if (deprecatedMaps.isEmpty()) {
                    return;
                }
                String deprecatedLogs = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)deprecatedMaps);
                OdpsDeprecatedLogger.getDeprecatedCalls().clear();
                String project = this.getDefaultProject();
                if (project == null) {
                    return;
                }
                String resource = ResourceBuilder.buildProjectResource(project);
                resource = resource + "/logs";
                byte[] bytes = deprecatedLogs.getBytes(CHARSET);
                ByteArrayInputStream body = new ByteArrayInputStream(bytes);
                this.requestWithNoRetry(resource, "PUT", null, null, body, bytes.length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, this.deprecatedLogThreadPool);
    }

    private void handleErrorResponse(Response resp) throws OdpsException {
        if (!resp.isOK()) {
            OdpsException e;
            ErrorMessage error = ErrorMessage.from(resp.getBody());
            if (resp.getStatus() == 404) {
                e = error != null ? new NoSuchObjectException(error.getMessage(), new RestException(error)) : new NoSuchObjectException("No such object.");
            } else {
                Map<String, String> errorHeader;
                if (error != null) {
                    e = new OdpsException(error.getMessage(), new RestException(error));
                } else {
                    String errorMessage = resp.getBody() == null ? null : new String(resp.getBody());
                    e = new OdpsException(errorMessage);
                }
                if (resp.getStatus() == 429 && (errorHeader = resp.getHeaders()) != null && errorHeader.containsKey("Retry-After") && errorHeader.get("Retry-After") != null) {
                    e.setRetryAfter(errorHeader.get("Retry-After"));
                }
            }
            e.setStatus(resp.getStatus());
            throw e;
        }
    }

    private void resetBody(InputStream body) {
        if (body != null && body.markSupported()) {
            try {
                body.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Response requestWithNoRetry(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, long bodyLen) throws OdpsException {
        Response resp = null;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        try {
            if (body != null) {
                headers.put("Content-Length", String.valueOf(bodyLen));
                if (!headers.containsKey("Content-MD5") && bodyLen > 0L) {
                    String contentMd5 = Hex.encodeHexString((byte[])DigestUtils.md5((InputStream)body));
                    IOUtils.resetInputStream(body);
                    headers.put("Content-MD5", contentMd5);
                }
            } else {
                headers.put("Content-Length", "0");
            }
            Request req = this.buildRequest(resource, method, params, headers);
            req.setBody(body);
            req.setBodyLength(bodyLen);
            resp = this.transport.request(req);
            return resp;
        }
        catch (SSLHandshakeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ConnectException | SocketTimeoutException e) {
            throw new OdpsException(e.getMessage() + ", the possible reason is that the endpoint `" + this.endpoint + "` is wrong, please check your endpoint", e);
        }
        catch (SocketException e) {
            throw new OdpsException(e.getMessage() + ", the possible reason is that read/write after socket closed, please check your socket", e);
        }
        catch (IOException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Connection connect(String resource, String method, Map<String, String> params, Map<String, String> headers) throws OdpsException, IOException {
        Request req = this.buildRequest(resource, method, params, headers);
        return this.transport.connect(req);
    }

    public Connection connect(String resource, String method, Map<String, String> params, Map<String, String> headers, String endpoint) throws OdpsException, IOException {
        Request req = this.buildRequest(resource, method, params, headers, endpoint);
        return this.transport.connect(req);
    }

    @Survey
    public Response requestForRawResponse(String resource, String method, Map<String, String> params, Map<String, String> headers, InputStream body, int length) throws OdpsException, IOException {
        return this.requestWithNoRetry(resource, method, params, headers, body, length);
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAppAccount(AppAccount appAccount) {
        this.appAccount = appAccount;
    }

    public void setAppStsAccount(AppStsAccount appStsAccount) {
        this.appStsAccount = appStsAccount;
    }

    public AppAccount getAppAccount() {
        return this.appAccount;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(String schema) {
        this.currentSchema = schema;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Survey
    public Transport getTransport() {
        return this.transport;
    }

    public Request buildRequest(String resource, String method, Map<String, String> params, Map<String, String> headers) {
        return this.buildRequest(resource, method, params, headers, this.endpoint);
    }

    protected Request buildRequest(String resource, String method, Map<String, String> params, Map<String, String> headers, String endpoint) {
        if (resource == null || !resource.startsWith("/")) {
            throw new IllegalArgumentException("Invalid resource: " + resource);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Odps endpoint required.");
        }
        Request req = new Request(this);
        StringBuilder url = new StringBuilder();
        url.append(endpoint).append(resource);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!params.containsKey("curr_project") && !StringUtils.isNullOrEmpty((String)this.defaultProject)) {
            params.put("curr_project", this.defaultProject);
        }
        if (params.size() != 0) {
            req.setParameters(params);
            url.append('?');
            boolean first = true;
            for (Map.Entry<String, String> kv : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    url.append('&');
                }
                String key = kv.getKey();
                String value = kv.getValue();
                url.append(key);
                if (value == null || value.length() <= 0) continue;
                value = ResourceBuilder.encode(value);
                url.append('=').append(value);
            }
        }
        try {
            req.setURI(new URI(url.toString()));
            req.setMethod(Request.Method.valueOf(method));
            Map<String, String> reqHeaders = req.getHeaders();
            if (!this.userDefinedHeaders.isEmpty()) {
                reqHeaders.putAll(this.userDefinedHeaders);
            }
            if (headers != null) {
                reqHeaders.putAll(headers);
            }
            req.setHeaders(reqHeaders);
            if (req.getHeaders().get("User-Agent") == null && this.userAgent != null) {
                req.setHeader("User-Agent", this.userAgent);
                req.setHeader("x-odps-user-agent", this.userAgent);
            }
            req.setHeader("Date", DateUtils.formatRfc822Date(new Date()));
            this.account.getRequestSigner().sign(resource, req);
            if (this.appAccount != null) {
                this.appAccount.getRequestSigner().sign(resource, req);
            }
            if (this.appStsAccount != null) {
                this.appStsAccount.getRequestSigner().sign(resource, req);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return req;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = (USER_AGENT_PREFIX + " " + userAgent).trim();
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean isIgnoreCerts() {
        return this.ignoreCerts;
    }

    public void setIgnoreCerts(boolean ignoreCerts) {
        this.ignoreCerts = ignoreCerts;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void enableDeprecatedLogger() {
        this.deprecatedLoggerEnabled = true;
    }

    public void disableDeprecatedLogger() {
        this.deprecatedLoggerEnabled = false;
    }

    public Map<String, String> getUserDefinedHeaders() {
        return this.userDefinedHeaders;
    }

    public void addUserDefinedHeader(String key, String value) {
        this.userDefinedHeaders.put(key, value);
    }

    public void setProxy(Proxy proxy) {
        if (!Proxy.Type.HTTP.equals((Object)proxy.type())) {
            throw new IllegalArgumentException("Unsupported proxy type: " + (Object)((Object)proxy.type()) + " support HTTP only");
        }
        this.proxy = proxy;
        this.transport.setProxy(proxy);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public static abstract class RetryLogger {
        public abstract void onRetryLog(Throwable var1, long var2, long var4);
    }

    static class RestRetryStrategy
    extends RetryStrategy {
        RestRetryStrategy(int limit, BackOffStrategy strategy) {
            super(limit, strategy);
        }

        @Override
        protected boolean needRetry(Exception e) {
            OdpsException err;
            if (e instanceof OdpsException && (err = (OdpsException)e).getStatus() != null && err.getStatus() / 100 == 4) {
                return err.getStatus() == 429 && err.existRetryAfter();
            }
            return true;
        }
    }
}

