/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.data.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class SimpleJsonValue
implements JsonValue {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private JsonNode value;

    public SimpleJsonValue(String value) {
        try {
            this.value = OBJECT_MAPPER.readTree(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal argument for JsonValue value.");
        }
    }

    public SimpleJsonValue(JsonNode jsonNode) {
        this.value = jsonNode;
    }

    public int size() {
        if (!this.value.isArray()) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = (ArrayNode)this.value;
        return arrayNode.size();
    }

    public boolean isJsonPrimitive() {
        return !this.value.isArray() && !this.value.isObject();
    }

    public boolean isJsonArray() {
        return this.value.isArray();
    }

    public boolean isJsonObject() {
        return this.value.isObject();
    }

    public boolean isJsonNull() {
        return this.value.isNull();
    }

    public JsonValue get(int index) {
        if (!this.isJsonArray()) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = (ArrayNode)this.value;
        return new SimpleJsonValue(arrayNode.get(index));
    }

    public JsonValue get(String filedName) {
        if (!this.isJsonObject()) {
            throw new UnsupportedOperationException();
        }
        ObjectNode objectNode = (ObjectNode)this.value;
        return new SimpleJsonValue(objectNode.get(filedName));
    }

    public Boolean getAsBoolean() {
        if (!this.value.isBoolean()) {
            throw new UnsupportedOperationException();
        }
        return this.value.asBoolean();
    }

    public Number getAsNumber() {
        if (!this.value.isNumber()) {
            throw new UnsupportedOperationException();
        }
        return new Number(){
            private static final long serialVersionUID = -8816955119176578371L;

            @Override
            public int intValue() {
                return SimpleJsonValue.this.value.asInt();
            }

            @Override
            public long longValue() {
                return SimpleJsonValue.this.value.asLong();
            }

            @Override
            public float floatValue() {
                return (float)SimpleJsonValue.this.value.asDouble();
            }

            @Override
            public double doubleValue() {
                return SimpleJsonValue.this.value.asDouble();
            }
        };
    }

    public String getAsString() {
        if (!this.value.isTextual()) {
            throw new UnsupportedOperationException();
        }
        return this.value.asText();
    }

    public String toString() {
        return this.value.toString();
    }
}

