/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.ha3engine.async.core.interceptor;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.darabonbastring.Client;
import com.aliyun.sdk.ha3engine.async.core.AsyncConfigInfoProvider;
import com.aliyun.tea.TeaException;
import com.aliyun.teautil.Common;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class SigningInterceptor
implements HttpRequestInterceptor {
    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        TeaConfiguration configuration = context.configuration();
        AsyncConfigInfoProvider provider = (AsyncConfigInfoProvider)configuration.clientConfiguration().option(ClientOption.CREDENTIALS_PROVIDER);
        Map headers = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("host", (Object)configuration.endpoint()), new TeaPair("authorization", (Object)("Basic " + this.getRealmSignStr(provider.getUsername(), provider.getPassword()) + "")), new TeaPair("content-type", (Object)"application/json; charset=utf-8")}), request.headers().toMap()});
        if (!Common.isUnset((Object)request.query())) {
            headers.put("X-Opensearch-Request-ID", Common.getNonce());
        }
        if (!Common.isUnset((Object)request.body())) {
            headers.put("X-Opensearch-Swift-Request-ID", Common.getNonce());
        }
        HttpHeaders httpHeaders = new HttpHeaders(headers);
        HttpRequest httpRequest = new HttpRequest(Optional.ofNullable(configuration.method()).orElseGet(() -> ((TeaRequest)request).method()), ModelUtil.composeUrl((String)configuration.endpoint(), (Map)request.query(), (String)configuration.protocol(), (String)request.pathname()));
        httpRequest.setHeaders(httpHeaders);
        httpRequest.setBody(Common.toJSONString((Object)request.body()));
        return httpRequest;
    }

    private String getRealmSignStr(String accessUserName, String accessPassWord) {
        try {
            String accessUserNameStr = Client.trim((String)accessUserName);
            String accessPassWordStr = Client.trim((String)accessPassWord);
            String realmStr = "" + accessUserNameStr + ":" + accessPassWordStr + "";
            return Encoder.base64EncodeToString((byte[])Client.toBytes((String)realmStr, (String)"UTF-8"));
        }
        catch (Exception e) {
            throw new TeaException();
        }
    }

    private String getUserAgent() {
        Properties sysProps = System.getProperties();
        return String.format("AlibabaCloud (%s; %s) Java/%s %s/%s TeaDSL/1", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), "tea-util", "0.2.21");
    }
}

