/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.ha3engine.async.core.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaPair;
import com.aliyun.teautil.Common;
import darabonba.core.TeaResponse;
import darabonba.core.exception.ClientException;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import java.util.Map;

public class ResponseBodyInterceptor
implements ResponseInterceptor {
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        try {
            this.handleResponseBody(response);
        }
        catch (TeaException e) {
            response.setException((Exception)new ClientException(Common.toJSONString((Object)e.getData()), (Throwable)e));
        }
        return response;
    }

    private void handleResponseBody(TeaResponse response) {
        int statusCode = response.httpResponse().getStatusCode();
        String responseBody = response.httpResponse().getBodyAsString();
        if (Common.is4xx((Number)statusCode) || Common.is5xx((Number)statusCode)) {
            Map rawMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("errors", (Object)responseBody)});
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)"FAIL"), new TeaPair("data", (Object)rawMap), new TeaPair("code", (Object)statusCode)}));
        }
        if (Common.empty((String)responseBody)) {
            Map responseMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("status", (Object)"OK"), new TeaPair("code", (Object)statusCode)});
            response.setDeserializedBody((Object)Common.toJSONString((Object)responseMap));
            return;
        }
        if (response.success()) {
            response.setDeserializedBody((Object)responseBody);
        }
    }
}

