/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientPublisherInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientServiceInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSubscriberInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClientSummaryInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ClusterInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.InstanceMetadataBatchResult;
import com.alibaba.nacos.api.naming.pojo.maintainer.MetricsInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceDetailInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceView;
import com.alibaba.nacos.api.naming.pojo.maintainer.SubscriberInfo;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.maintainer.client.core.AbstractCoreMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.naming.NamingMaintainerService;
import com.alibaba.nacos.maintainer.client.utils.RequestUtil;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosNamingMaintainerServiceImpl
extends AbstractCoreMaintainerService
implements NamingMaintainerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosNamingMaintainerServiceImpl.class);

    public NacosNamingMaintainerServiceImpl(Properties properties) throws NacosException {
        super(properties);
    }

    @Override
    public String createService(Service service) throws NacosException {
        service.validate();
        Map<String, String> params = RequestUtil.toParameters(service);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("POST").setPath("/v3/admin/ns/service").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String updateService(Service service) throws NacosException {
        service.validate();
        Map<String, String> params = RequestUtil.toParameters(service);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/service").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String removeService(Service service) throws NacosException {
        service.validate();
        Map<String, String> params = RequestUtil.toParameters(service);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("DELETE").setPath("/v3/admin/ns/service").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public ServiceDetailInfo getServiceDetail(Service service) throws NacosException {
        service.validate();
        Map<String, String> params = RequestUtil.toParameters(service);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/service").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ServiceDetailInfo>>(){});
        return (ServiceDetailInfo)result.getData();
    }

    @Override
    public Page<ServiceView> listServices(String namespaceId, String groupNameParam, String serviceNameParam, boolean ignoreEmptyService, int pageNo, int pageSize) throws NacosException {
        HttpRestResult<String> httpRestResult = this.doListServices(namespaceId, groupNameParam, serviceNameParam, false, ignoreEmptyService, pageNo, pageSize);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Page<ServiceView>>>(){});
        return (Page)result.getData();
    }

    @Override
    public Page<ServiceDetailInfo> listServicesWithDetail(String namespaceId, String groupNameParam, String serviceNameParam, int pageNo, int pageSize) throws NacosException {
        HttpRestResult<String> httpRestResult = this.doListServices(namespaceId, groupNameParam, serviceNameParam, true, false, pageNo, pageSize);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Page<ServiceDetailInfo>>>(){});
        return (Page)result.getData();
    }

    private HttpRestResult<String> doListServices(String namespaceId, String groupNameParam, String serviceNameParam, boolean withInstances, boolean ignoreEmptyService, int pageNo, int pageSize) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        params.put("groupNameParam", groupNameParam);
        params.put("serviceNameParam", serviceNameParam);
        params.put("withInstances", String.valueOf(withInstances));
        params.put("ignoreEmptyService", String.valueOf(ignoreEmptyService));
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        RequestResource resource = this.buildRequestResource(namespaceId, null, null);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/service/list").setParamValue(params).build();
        return this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
    }

    @Override
    public Page<SubscriberInfo> getSubscribers(Service service, int pageNo, int pageSize, boolean aggregation) throws NacosException {
        service.validate();
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("aggregation", String.valueOf(aggregation));
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/service/subscribers").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        return (Page)((Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Page<SubscriberInfo>>>(){})).getData();
    }

    @Override
    public List<String> listSelectorTypes() throws NacosException {
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/service/selector/types").build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        return (List)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<List<String>>(){});
    }

    @Override
    public MetricsInfo getMetrics(boolean onlyStatus) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("onlyStatus", String.valueOf(onlyStatus));
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/ops/metrics").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<MetricsInfo>>(){});
        return (MetricsInfo)result.getData();
    }

    @Override
    public String setLogLevel(String logName, String logLevel) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("logName", logName);
        params.put("logLevel", logLevel);
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("PUT").setPath("/v3/admin/ns/ops/log").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String registerInstance(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        this.checkEphemeral(service, instance);
        if (instance.isEphemeral()) {
            LOGGER.warn("Using maintainer client to register an ephemeral instance, the instance will be auto-deregister after {} milliseconds.", (Object)instance.getIpDeleteTimeout());
            LOGGER.warn("Strongly recommended to use the nacos-client for ephemeral instance registration to avoid auto-deregister.");
            LOGGER.warn("If wanted to register ephemeral instance with maintainer client, please set `{}` in instance metadata to delay auto-deregister time.", (Object)"preserved.ip.delete.timeout");
        }
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("POST").setPath("/v3/admin/ns/instance").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String deregisterInstance(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        this.checkEphemeral(service, instance);
        if (instance.isEphemeral()) {
            LOGGER.warn("De-registering an ephemeral instance from service {}@@{}.", (Object)service.getGroupName(), (Object)service.getName());
            LOGGER.warn("De-registering an ephemeral instance might fail due to the nacos-client registered this instance is keeping connection");
            LOGGER.warn("If you want to de-register this ephemeral instance, please use the nacos-client which registered this instance.");
        }
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("DELETE").setPath("/v3/admin/ns/instance").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String updateInstance(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        this.checkEphemeral(service, instance);
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/instance").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public InstanceMetadataBatchResult batchUpdateInstanceMetadata(Service service, List<Instance> instances, Map<String, String> newMetadata) throws NacosException {
        service.validate();
        if (Objects.isNull(newMetadata)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Parameter `newMetadata` can't be null");
        }
        if (instances.isEmpty()) {
            return new InstanceMetadataBatchResult(Collections.emptyList());
        }
        for (Instance each : instances) {
            each.validate();
        }
        this.checkEphemeral(service, instances.get(0));
        Map<String, String> params = RequestUtil.toParameters(service, instances, newMetadata);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/instance/metadata/batch").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<InstanceMetadataBatchResult>>(){});
        return (InstanceMetadataBatchResult)result.getData();
    }

    @Override
    public InstanceMetadataBatchResult batchDeleteInstanceMetadata(Service service, List<Instance> instances, Map<String, String> newMetadata) throws NacosException {
        service.validate();
        if (Objects.isNull(newMetadata)) {
            throw new NacosApiException(400, ErrorCode.PARAMETER_MISSING, "Parameter `newMetadata` can't be null");
        }
        if (instances.isEmpty() || newMetadata.isEmpty()) {
            return new InstanceMetadataBatchResult(Collections.emptyList());
        }
        for (Instance each : instances) {
            each.validate();
        }
        this.checkEphemeral(service, instances.get(0));
        Map<String, String> params = RequestUtil.toParameters(service, instances, newMetadata);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("DELETE").setPath("/v3/admin/ns/instance/metadata/batch").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<InstanceMetadataBatchResult>>(){});
        return (InstanceMetadataBatchResult)result.getData();
    }

    @Override
    public String partialUpdateInstance(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        this.checkEphemeral(service, instance);
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/instance/partial").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public List<Instance> listInstances(Service service, String clusterName, boolean healthyOnly) throws NacosException {
        service.validate();
        if (StringUtils.isBlank((CharSequence)clusterName)) {
            clusterName = "DEFAULT";
        }
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("namespaceId", service.getNamespaceId());
        params.put("groupName", service.getGroupName());
        params.put("serviceName", service.getName());
        params.put("clusterName", clusterName);
        params.put("healthyOnly", String.valueOf(healthyOnly));
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/instance/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<Instance>>>(){});
        return (List)result.getData();
    }

    @Override
    public Instance getInstanceDetail(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/instance").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Instance>>(){});
        return (Instance)result.getData();
    }

    private void checkEphemeral(Service service, Instance instance) {
        if (service.isEphemeral() != instance.isEphemeral()) {
            LOGGER.warn("De-registering instance ephemeral parameters conflict, service: {}, instance: {}, will use instance value.", (Object)service.isEphemeral(), (Object)instance.isEphemeral());
        }
    }

    @Override
    public String updateInstanceHealthStatus(Service service, Instance instance) throws NacosException {
        service.validate();
        instance.validate();
        Map<String, String> params = RequestUtil.toParameters(service, instance);
        if (!service.isEphemeral() || !instance.isEphemeral()) {
            LOGGER.warn("Only persistent instance with NONE health checker can be updated healthy statues.");
            params.put("ephemeral", String.valueOf(Boolean.FALSE));
        }
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/health/instance").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public Map<String, AbstractHealthChecker> getHealthCheckers() throws NacosException {
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/health/checkers").build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        return (Map)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Map<String, AbstractHealthChecker>>(){});
    }

    @Override
    public String updateCluster(Service service, ClusterInfo cluster) throws NacosException {
        service.validate();
        cluster.validate();
        Map<String, String> params = RequestUtil.toParameters(service, cluster);
        RequestResource resource = this.buildRequestResource(service);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("PUT").setPath("/v3/admin/ns/cluster").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public List<String> getClientList() throws NacosException {
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/client/list").build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        return (List)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<List<String>>(){});
    }

    @Override
    public ClientSummaryInfo getClientDetail(String clientId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("clientId", clientId);
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/client").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ClientSummaryInfo>>(){});
        return (ClientSummaryInfo)result.getData();
    }

    @Override
    public List<ClientServiceInfo> getPublishedServiceList(String clientId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("clientId", clientId);
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/client/publish/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<ClientServiceInfo>>>(){});
        return (List)result.getData();
    }

    @Override
    public List<ClientServiceInfo> getSubscribeServiceList(String clientId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("clientId", clientId);
        HttpRequest httpRequest = this.buildRequestWithResource().setHttpMethod("GET").setPath("/v3/admin/ns/client/subscribe/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<ClientServiceInfo>>>(){});
        return (List)result.getData();
    }

    @Override
    public List<ClientPublisherInfo> getPublishedClientList(String namespaceId, String groupName, String serviceName, String ip, Integer port) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("namespaceId", namespaceId);
        params.put("groupName", groupName);
        params.put("serviceName", serviceName);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        RequestResource resource = this.buildRequestResource(namespaceId, groupName, serviceName);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/client/service/publisher/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<ClientPublisherInfo>>>(){});
        return (List)result.getData();
    }

    @Override
    public List<ClientSubscriberInfo> getSubscribeClientList(String namespaceId, String groupName, String serviceName, String ip, Integer port) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("namespaceId", namespaceId);
        params.put("groupName", groupName);
        params.put("serviceName", serviceName);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        RequestResource resource = this.buildRequestResource(namespaceId, groupName, serviceName);
        HttpRequest httpRequest = this.buildRequestWithResource(resource).setHttpMethod("GET").setPath("/v3/admin/ns/client/service/subscriber/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.getClientHttpProxy().executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<ClientSubscriberInfo>>>(){});
        return (List)result.getData();
    }

    private HttpRequest.Builder buildRequestWithResource() {
        return new HttpRequest.Builder().setResource(RequestResource.namingBuilder().setResource("").build());
    }

    private HttpRequest.Builder buildRequestWithResource(RequestResource resource) {
        return new HttpRequest.Builder().setResource(resource);
    }

    private RequestResource buildRequestResource(Service service) {
        return this.buildRequestResource(service.getNamespaceId(), service.getGroupName(), service.getName());
    }

    private RequestResource buildRequestResource(String namespaceId, String groupName, String serviceName) {
        RequestResource.Builder builder = RequestResource.namingBuilder();
        builder.setNamespace(namespaceId);
        builder.setGroup(groupName);
        builder.setResource(serviceName);
        return builder.build();
    }
}

