/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.ConnectionInfo;
import com.alibaba.nacos.api.model.response.IdGeneratorInfo;
import com.alibaba.nacos.api.model.response.NacosMember;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.api.model.response.ServerLoaderMetrics;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.maintainer.client.core.CoreMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.remote.ClientHttpProxy;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractCoreMaintainerService
implements CoreMaintainerService {
    private final ClientHttpProxy clientHttpProxy;

    protected AbstractCoreMaintainerService(Properties properties) throws NacosException {
        this.clientHttpProxy = new ClientHttpProxy(properties);
        ParamUtil.initSerialization();
    }

    @Override
    public Map<String, String> getServerState() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/state").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Map<String, String>>>(){});
        return (Map)result.getData();
    }

    @Override
    public Boolean liveness() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/state/liveness").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        return httpRestResult.ok();
    }

    @Override
    public Boolean readiness() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/ops/readiness").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        return httpRestResult.ok();
    }

    @Override
    public String raftOps(String command, String value, String groupId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("command", command);
        params.put("value", value);
        params.put("groupId", groupId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/core/ops/raft").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public List<IdGeneratorInfo> getIdGenerators() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/ops/ids").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<IdGeneratorInfo>>>(){});
        return (List)result.getData();
    }

    @Override
    public void updateLogLevel(String logName, String logLevel) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("logName", logName);
        params.put("logLevel", logLevel);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("PUT").setPath("/v3/admin/core/ops/log").setParamValue(params).build();
        this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
    }

    @Override
    public Collection<NacosMember> listClusterNodes(String address, String state) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("address", address);
        params.put("state", state);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/cluster/node/list").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Collection<NacosMember>>>(){});
        return (Collection)result.getData();
    }

    @Override
    public Boolean updateLookupMode(String type) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("type", type);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("PUT").setPath("/v3/admin/core/cluster/lookup").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public Map<String, ConnectionInfo> getCurrentClients() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/loader/current").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Map<String, ConnectionInfo>>>(){});
        return (Map)result.getData();
    }

    @Override
    public String reloadConnectionCount(Integer count, String redirectAddress) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("count", String.valueOf(count));
        params.put("redirectAddress", redirectAddress);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/core/loader/reloadCurrent").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String smartReloadCluster(String loaderFactorStr) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("loaderFactorStr", loaderFactorStr);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/core/loader/smartReloadCluster").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public String reloadSingleClient(String connectionId, String redirectAddress) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("connectionId", connectionId);
        params.put("redirectAddress", redirectAddress);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/core/loader/reloadClient").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return (String)result.getData();
    }

    @Override
    public ServerLoaderMetrics getClusterLoaderMetrics() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/loader/cluster").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<ServerLoaderMetrics>>(){});
        return (ServerLoaderMetrics)result.getData();
    }

    @Override
    public List<Namespace> getNamespaceList() throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/namespace/list").build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<List<Namespace>>>(){});
        return (List)result.getData();
    }

    @Override
    public Namespace getNamespace(String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/namespace").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Namespace>>(){});
        return (Namespace)result.getData();
    }

    @Override
    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        params.put("namespaceName", namespaceName);
        params.put("namespaceDesc", namespaceDesc);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/core/namespace").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public Boolean updateNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        params.put("namespaceName", namespaceName);
        params.put("namespaceDesc", namespaceDesc);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("PUT").setPath("/v3/admin/core/namespace").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public Boolean deleteNamespace(String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("DELETE").setPath("/v3/admin/core/namespace").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Boolean>>(){});
        return (Boolean)result.getData();
    }

    @Override
    public Boolean checkNamespaceIdExist(String namespaceId) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", namespaceId);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/core/namespace/check").setParamValue(params).build();
        HttpRestResult<String> httpRestResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)httpRestResult.getData()), (TypeReference)new TypeReference<Result<Integer>>(){});
        return (Integer)result.getData() > 0;
    }

    protected ClientHttpProxy getClientHttpProxy() {
        return this.clientHttpProxy;
    }

    public void shutdown() throws NacosException {
        this.clientHttpProxy.shutdown();
    }
}

