/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.response;

import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

public class DefaultClientHttpResponse
implements HttpClientResponse {
    private SimpleHttpResponse response;
    private InputStream responseStream;
    private Header responseHeader;

    public DefaultClientHttpResponse(SimpleHttpResponse response) {
        this.response = response;
    }

    @Override
    public int getStatusCode() {
        return this.response.getCode();
    }

    @Override
    public String getStatusText() {
        return this.response.getReasonPhrase();
    }

    @Override
    public Header getHeaders() {
        if (this.responseHeader == null) {
            org.apache.hc.core5.http.Header[] allHeaders;
            this.responseHeader = Header.newInstance();
            for (org.apache.hc.core5.http.Header header : allHeaders = this.response.getHeaders()) {
                this.responseHeader.addParam(header.getName(), header.getValue());
            }
        }
        return this.responseHeader;
    }

    @Override
    public InputStream getBody() {
        byte[] bodyBytes = this.response.getBody().getBodyBytes();
        this.responseStream = bodyBytes != null ? new ByteArrayInputStream(bodyBytes) : new ByteArrayInputStream(new byte[0]);
        return this.responseStream;
    }

    @Override
    public void close() {
        IoUtils.closeQuietly((Closeable)this.responseStream);
    }
}

