/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.DefaultSettingPropertySource;
import com.alibaba.nacos.client.env.JvmArgsPropertySource;
import com.alibaba.nacos.client.env.PropertiesPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import com.alibaba.nacos.client.env.SystemEnvPropertySource;
import com.alibaba.nacos.client.env.convert.CompositeConverter;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertySourceSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertySourceSearch.class);
    private static final List<SourceType> DEFAULT_ORDER = Arrays.asList(SourceType.PROPERTIES, SourceType.JVM, SourceType.SYS);
    private final List<AbstractPropertySource> propertySources;
    private final CompositeConverter converter;

    private PropertySourceSearch(List<AbstractPropertySource> propertySources) {
        this.propertySources = propertySources;
        this.propertySources.add(new DefaultSettingPropertySource());
        this.converter = new CompositeConverter();
    }

    static PropertySourceSearch build(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        PropertiesPropertySource customizePropertySource = new PropertiesPropertySource(properties);
        JvmArgsPropertySource jvmArgsPropertySource = new JvmArgsPropertySource();
        SystemEnvPropertySource systemEnvPropertySource = new SystemEnvPropertySource();
        String searchPattern = jvmArgsPropertySource.getProperty("nacos.envs.search");
        if (StringUtils.isBlank(searchPattern)) {
            searchPattern = systemEnvPropertySource.getProperty("nacos.envs.search");
        }
        return PropertySourceSearch.resolve(searchPattern, customizePropertySource, jvmArgsPropertySource, systemEnvPropertySource);
    }

    private static PropertySourceSearch resolve(String pattern, AbstractPropertySource ... propertySources) {
        if (StringUtils.isBlank(pattern)) {
            return PropertySourceSearch.createPropertySourceSearchWithDefaultOrder(propertySources);
        }
        try {
            SourceType sourceType = SourceType.valueOf(pattern.toUpperCase());
            return PropertySourceSearch.createPropertySourceSearchByFirstType(sourceType, propertySources);
        }
        catch (Exception e) {
            LOGGER.error("first source type parse error, it will be use default order!");
            return PropertySourceSearch.createPropertySourceSearchWithDefaultOrder(propertySources);
        }
    }

    private static PropertySourceSearch createPropertySourceSearchWithDefaultOrder(AbstractPropertySource ... propertySources) {
        Map<SourceType, AbstractPropertySource> sourceMap = Arrays.stream(propertySources).collect(Collectors.toMap(AbstractPropertySource::getType, propertySource -> propertySource));
        List<AbstractPropertySource> collect = DEFAULT_ORDER.stream().map(sourceMap::get).collect(Collectors.toList());
        return new PropertySourceSearch(collect);
    }

    private static PropertySourceSearch createPropertySourceSearchByFirstType(SourceType firstType, AbstractPropertySource ... propertySources) {
        ArrayList<SourceType> tempList = new ArrayList<SourceType>(4);
        tempList.add(firstType);
        Map<SourceType, AbstractPropertySource> sourceMap = Arrays.stream(propertySources).collect(Collectors.toMap(AbstractPropertySource::getType, propertySource -> propertySource));
        List<AbstractPropertySource> collect = DEFAULT_ORDER.stream().filter(sourceType -> !sourceType.equals((Object)firstType)).collect(() -> tempList, List::add, List::addAll).stream().map(sourceMap::get).collect(Collectors.toList());
        return new PropertySourceSearch(collect);
    }

    <T> Optional<T> search(String key, Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type must be not null!");
        }
        for (AbstractPropertySource propertySource : this.propertySources) {
            String value = propertySource.getProperty(key);
            if (value == null) continue;
            if (String.class.isAssignableFrom(targetType)) {
                return Optional.of(value);
            }
            return Optional.ofNullable(this.converter.convert(value, targetType));
        }
        return Optional.empty();
    }
}

