/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.ClientWorker;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.ParamUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.ValidatorUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;

public class NacosConfigService
implements ConfigService {
    private static final Logger LOGGER = LogUtils.logger(NacosConfigService.class);
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    @Deprecated
    ServerHttpAgent agent = null;
    private final ClientWorker worker;
    private String namespace;
    private final ConfigFilterChainManager configFilterChainManager;

    public NacosConfigService(Properties properties) throws NacosException {
        ValidatorUtils.checkInitParam(properties);
        this.initNamespace(properties);
        this.configFilterChainManager = new ConfigFilterChainManager(properties);
        ServerListManager serverListManager = new ServerListManager(properties);
        serverListManager.start();
        this.worker = new ClientWorker(this.configFilterChainManager, serverListManager, properties);
        this.agent = new ServerHttpAgent(serverListManager);
    }

    private void initNamespace(Properties properties) {
        this.namespace = ParamUtil.parseNamespace(properties);
        properties.put("namespace", this.namespace);
    }

    @Override
    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        return this.getConfigInner(this.namespace, dataId, group, timeoutMs);
    }

    @Override
    public String getConfigAndSignListener(String dataId, String group, long timeoutMs, Listener listener) throws NacosException {
        group = StringUtils.isBlank(group) ? "DEFAULT_GROUP" : group.trim();
        ConfigResponse configResponse = this.worker.getAgent().queryConfig(dataId, group, this.worker.getAgent().getTenant(), timeoutMs, false);
        String content = configResponse.getContent();
        String encryptedDataKey = configResponse.getEncryptedDataKey();
        this.worker.addTenantListenersWithContent(dataId, group, content, encryptedDataKey, Arrays.asList(listener));
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setGroup(group);
        cr.setContent(content);
        cr.setEncryptedDataKey(encryptedDataKey);
        this.configFilterChainManager.doFilter(null, cr);
        return cr.getContent();
    }

    @Override
    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.worker.addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    @Override
    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.publishConfig(dataId, group, content, ConfigType.getDefaultType().getType());
    }

    @Override
    public boolean publishConfig(String dataId, String group, String content, String type) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content, type, null);
    }

    @Override
    public boolean publishConfigCas(String dataId, String group, String content, String casMd5) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content, ConfigType.getDefaultType().getType(), casMd5);
    }

    @Override
    public boolean publishConfigCas(String dataId, String group, String content, String casMd5, String type) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content, type, casMd5);
    }

    @Override
    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.removeConfigInner(this.namespace, dataId, group, null);
    }

    @Override
    public void removeListener(String dataId, String group, Listener listener) {
        this.worker.removeTenantListener(dataId, group, listener);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws NacosException {
        group = this.blank2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        String content = LocalConfigInfoProcessor.getFailover(this.worker.getAgentName(), dataId, group, tenant);
        if (content != null) {
            LOGGER.warn("[{}] [get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.worker.getAgentName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            cr.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this.agent.getName(), dataId, group, tenant);
            cr.setEncryptedDataKey(encryptedDataKey);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        try {
            ConfigResponse response = this.worker.getServerConfig(dataId, group, tenant, timeoutMs, false);
            cr.setContent(response.getContent());
            cr.setEncryptedDataKey(response.getEncryptedDataKey());
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        catch (NacosException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            LOGGER.warn("[{}] [get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", new Object[]{this.worker.getAgentName(), dataId, group, tenant, ioe.toString()});
            content = LocalConfigInfoProcessor.getSnapshot(this.worker.getAgentName(), dataId, group, tenant);
            if (content != null) {
                LOGGER.warn("[{}] [get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.worker.getAgentName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            }
            cr.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(this.agent.getName(), dataId, group, tenant);
            cr.setEncryptedDataKey(encryptedDataKey);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
    }

    private String blank2defaultGroup(String group) {
        return StringUtils.isBlank(group) ? "DEFAULT_GROUP" : group.trim();
    }

    private boolean removeConfigInner(String tenant, String dataId, String group, String tag) throws NacosException {
        group = this.blank2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        return this.worker.removeConfig(dataId, group, tenant, tag);
    }

    private boolean publishConfigInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content, String type, String casMd5) throws NacosException {
        group = this.blank2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        ConfigRequest cr = new ConfigRequest();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        cr.setType(type);
        this.configFilterChainManager.doFilter(cr, null);
        content = cr.getContent();
        String encryptedDataKey = cr.getEncryptedDataKey();
        return this.worker.publishConfig(dataId, group, tenant, appName, tag, betaIps, content, encryptedDataKey, casMd5, type);
    }

    @Override
    public String getServerStatus() {
        if (this.worker.isHealthServer()) {
            return UP;
        }
        return DOWN;
    }

    @Override
    public void shutDown() throws NacosException {
        this.worker.shutdown();
    }
}

