/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.IpUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.List;

public class ParamUtils {
    private static final char[] VALID_CHARS = new char[]{'_', '-', '.', ':'};

    public static boolean isValid(String param) {
        if (param == null) {
            return false;
        }
        int length = param.length();
        for (int i = 0; i < length; ++i) {
            char ch = param.charAt(i);
            if (Character.isLetterOrDigit(ch) || ParamUtils.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        for (char c : VALID_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static void checkTdg(String tenant, String dataId, String group) throws NacosException {
        ParamUtils.checkTenant(tenant);
        if (StringUtils.isBlank((String)dataId) || !ParamUtils.isValid(dataId)) {
            throw new NacosException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank((String)group) || !ParamUtils.isValid(group)) {
            throw new NacosException(-400, "group invalid");
        }
    }

    public static void checkKeyParam(String dataId, String group) throws NacosException {
        if (StringUtils.isBlank((String)dataId) || !ParamUtils.isValid(dataId)) {
            throw new NacosException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank((String)group) || !ParamUtils.isValid(group)) {
            throw new NacosException(-400, "group invalid");
        }
    }

    public static void checkKeyParam(String dataId, String group, String datumId) throws NacosException {
        if (StringUtils.isBlank((String)dataId) || !ParamUtils.isValid(dataId)) {
            throw new NacosException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank((String)group) || !ParamUtils.isValid(group)) {
            throw new NacosException(-400, "group invalid");
        }
        if (StringUtils.isBlank((String)datumId) || !ParamUtils.isValid(datumId)) {
            throw new NacosException(-400, "datumId invalid");
        }
    }

    public static void checkKeyParam(List<String> dataIds, String group) throws NacosException {
        if (dataIds == null || dataIds.size() == 0) {
            throw new NacosException(-400, "dataIds invalid");
        }
        for (String dataId : dataIds) {
            if (!StringUtils.isBlank((String)dataId) && ParamUtils.isValid(dataId)) continue;
            throw new NacosException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank((String)group) || !ParamUtils.isValid(group)) {
            throw new NacosException(-400, "group invalid");
        }
    }

    public static void checkParam(String dataId, String group, String content) throws NacosException {
        ParamUtils.checkKeyParam(dataId, group);
        if (StringUtils.isBlank((String)content)) {
            throw new NacosException(-400, "content invalid");
        }
    }

    public static void checkParam(String dataId, String group, String datumId, String content) throws NacosException {
        ParamUtils.checkKeyParam(dataId, group, datumId);
        if (StringUtils.isBlank((String)content)) {
            throw new NacosException(-400, "content invalid");
        }
    }

    public static void checkTenant(String tenant) throws NacosException {
        if (StringUtils.isBlank((String)tenant) || !ParamUtils.isValid(tenant)) {
            throw new NacosException(-400, "tenant invalid");
        }
    }

    public static void checkBetaIps(String betaIps) throws NacosException {
        String[] ipsArr;
        if (StringUtils.isBlank((String)betaIps)) {
            throw new NacosException(-400, "betaIps invalid");
        }
        for (String ip : ipsArr = betaIps.split(",")) {
            if (IpUtils.isIpv4((String)ip)) continue;
            throw new NacosException(-400, "betaIps invalid");
        }
    }

    public static void checkContent(String content) throws NacosException {
        if (StringUtils.isBlank((String)content)) {
            throw new NacosException(-400, "content invalid");
        }
    }
}

