/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDeserializer
implements ObjectDeserializer {
    public static final ArrayDeserializer instance = new ArrayDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (lexer.token() == 4) {
            byte[] bytes = lexer.bytesValue();
            lexer.nextToken(16);
            return (T)bytes;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array);
        return this.toObjectArray(parser, (Class)clazz, array);
    }

    private <T> T toObjectArray(DefaultJSONParser parser, Class<T> clazz, JSONArray array) {
        if (array == null) {
            return null;
        }
        int size = array.size();
        Class<?> componentType = clazz.getComponentType();
        Object objArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object element;
            Object value = array.get(i);
            if (componentType.isArray()) {
                element = this.toObjectArray(parser, componentType, (JSONArray)value);
                Array.set(objArray, i, element);
                continue;
            }
            element = TypeUtils.cast(value, componentType, parser.getConfig());
            Array.set(objArray, i, element);
        }
        return (T)objArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

