/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.HashMap;
import java.util.Map;

public class HeartbeatMessage {
    private final Map<String, String> message = new HashMap<String, String>();

    public HeartbeatMessage() {
        this.message.put("hostname", HostNameUtil.getHostName());
        this.message.put("ip", TransportConfig.getHeartbeatClientIp());
        this.message.put("app", AppNameUtil.getAppName());
        this.message.put("app_type", String.valueOf(SentinelConfig.getAppType()));
        this.message.put("port", String.valueOf(TransportConfig.getPort()));
    }

    public HeartbeatMessage registerInformation(String key, String value) {
        this.message.put(key, value);
        return this;
    }

    public Map<String, String> generateCurrentMessage() {
        this.message.put("v", Constants.SENTINEL_VERSION);
        this.message.put("version", String.valueOf(TimeUtil.currentTimeMillis()));
        this.message.put("port", String.valueOf(TransportConfig.getPort()));
        return this.message;
    }
}

