/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractNacosDataParser;
import com.alibaba.cloud.nacos.parser.NacosDataJsonParser;
import com.alibaba.cloud.nacos.parser.NacosDataPropertiesParser;
import com.alibaba.cloud.nacos.parser.NacosDataXmlParser;
import com.alibaba.cloud.nacos.parser.NacosDataYamlParser;
import java.io.IOException;
import java.util.Map;

public final class NacosDataParserHandler {
    private AbstractNacosDataParser parser = this.createParser();

    private NacosDataParserHandler() {
    }

    public Map<String, Object> parseNacosData(String data, String extension) throws IOException {
        if (null == this.parser) {
            this.parser = this.createParser();
        }
        return this.parser.parseNacosData(data, extension);
    }

    public boolean checkDataId(String ... dataIdAry) {
        String extension;
        String dataId;
        int idx;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dataIdAry;
        int n = stringArray.length;
        for (int i = 0; !(i >= n || (idx = (dataId = stringArray[i]).lastIndexOf(".")) > 0 && idx < dataId.length() - 1 && this.parser.checkFileExtension(extension = dataId.substring(idx + 1))); ++i) {
            stringBuilder.append(dataId).append(",");
        }
        if (stringBuilder.length() > 0) {
            String result = stringBuilder.substring(0, stringBuilder.length() - 1);
            throw new IllegalStateException(AbstractNacosDataParser.getTips(result));
        }
        return true;
    }

    private AbstractNacosDataParser createParser() {
        return new NacosDataPropertiesParser().addNextParser(new NacosDataYamlParser()).addNextParser(new NacosDataXmlParser()).addNextParser(new NacosDataJsonParser());
    }

    public static NacosDataParserHandler getInstance() {
        return ParserHandler.HANDLER;
    }

    private static class ParserHandler {
        private static final NacosDataParserHandler HANDLER = new NacosDataParserHandler();

        private ParserHandler() {
        }
    }
}

