/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.FiltersPerformance;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import java.util.Arrays;

public class PixelsWriterDefault
extends PixelsWriter {
    protected byte[] rowb;
    protected byte[] rowbprev;
    protected byte[] rowbfilter;
    protected FiltersPerformance filtersPerformance;
    protected FilterType curfilterType;
    protected int adaptMaxSkip;
    protected int adaptSkipIncreaseSinceRow;
    protected double adaptSkipIncreaseFactor;
    protected int adaptNextRow = 0;

    public PixelsWriterDefault(ImageInfo imageInfo) {
        super(imageInfo);
        this.filtersPerformance = new FiltersPerformance(imageInfo);
    }

    @Override
    protected void initParams() {
        super.initParams();
        if (this.rowb == null || this.rowb.length < this.buflen) {
            this.rowb = new byte[this.buflen];
        }
        if (this.rowbfilter == null || this.rowbfilter.length < this.buflen) {
            this.rowbfilter = new byte[this.buflen];
        }
        if (this.rowbprev == null || this.rowbprev.length < this.buflen) {
            this.rowbprev = new byte[this.buflen];
        } else {
            Arrays.fill(this.rowbprev, (byte)0);
        }
        if (this.imgInfo.cols < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        if (this.imgInfo.rows < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        if (this.imgInfo.getTotalPixels() <= 1024L && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = this.getDefaultFilter();
        }
        if (FilterType.isAdaptive(this.filterType)) {
            this.adaptNextRow = 0;
            if (this.filterType == FilterType.FILTER_ADAPTIVE_FAST) {
                this.adaptMaxSkip = 200;
                this.adaptSkipIncreaseSinceRow = 3;
                this.adaptSkipIncreaseFactor = 0.25;
            } else if (this.filterType == FilterType.FILTER_ADAPTIVE_MEDIUM) {
                this.adaptMaxSkip = 8;
                this.adaptSkipIncreaseSinceRow = 32;
                this.adaptSkipIncreaseFactor = 0.0125;
            } else if (this.filterType == FilterType.FILTER_ADAPTIVE_FULL) {
                this.adaptMaxSkip = 0;
                this.adaptSkipIncreaseSinceRow = 128;
                this.adaptSkipIncreaseFactor = 0.008333333333333333;
            } else {
                throw new PngjOutputException("bad filter " + (Object)((Object)this.filterType));
            }
        }
    }

    @Override
    protected void filterAndWrite(byte[] byArray) {
        if (byArray != this.rowb) {
            throw new RuntimeException("??");
        }
        this.decideCurFilterType();
        byte[] byArray2 = this.filterRowWithFilterType(this.curfilterType, byArray, this.rowbprev, this.rowbfilter);
        this.sendToCompressedStream(byArray2);
        byte[] byArray3 = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray3;
    }

    protected void decideCurFilterType() {
        if (FilterType.isValidStandard(this.getFilterType())) {
            this.curfilterType = this.getFilterType();
        } else if (this.getFilterType() == FilterType.FILTER_PRESERVE) {
            this.curfilterType = FilterType.getByVal(this.rowb[0]);
        } else if (this.getFilterType() == FilterType.FILTER_CYCLIC) {
            this.curfilterType = FilterType.getByVal(this.currentRow % 5);
        } else if (this.getFilterType() == FilterType.FILTER_DEFAULT) {
            this.setFilterType(this.getDefaultFilter());
            this.curfilterType = this.getFilterType();
        } else if (FilterType.isAdaptive(this.getFilterType())) {
            if (this.currentRow == this.adaptNextRow) {
                int n;
                for (FilterType filterType : FilterType.getAllStandard()) {
                    this.filtersPerformance.updateFromRaw(filterType, this.rowb, this.rowbprev, this.currentRow);
                }
                this.curfilterType = this.filtersPerformance.getPreferred();
                int n2 = n = this.currentRow >= this.adaptSkipIncreaseSinceRow ? (int)Math.round((double)(this.currentRow - this.adaptSkipIncreaseSinceRow) * this.adaptSkipIncreaseFactor) : 0;
                if (n > this.adaptMaxSkip) {
                    n = this.adaptMaxSkip;
                }
                if (this.currentRow == 0) {
                    n = 0;
                }
                this.adaptNextRow = this.currentRow + 1 + n;
            }
        } else {
            throw new PngjOutputException("not implemented filter: " + (Object)((Object)this.getFilterType()));
        }
        if (this.currentRow == 0 && this.curfilterType != FilterType.FILTER_NONE && this.curfilterType != FilterType.FILTER_SUB) {
            this.curfilterType = FilterType.FILTER_SUB;
        }
    }

    @Override
    public byte[] getRowb() {
        if (!this.initdone) {
            this.init();
        }
        return this.rowb;
    }

    @Override
    public void close() {
        super.close();
    }

    public void setPreferenceForNone(double d) {
        this.filtersPerformance.setPreferenceForNone(d);
    }

    public void tuneMemory(double d) {
        this.filtersPerformance.tuneMemory(d);
    }

    public void setFilterWeights(double[] dArray) {
        this.filtersPerformance.setFilterWeights(dArray);
    }
}

