/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IdatChunkWriter;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.CompressorStreamDeflater;
import ar.com.hjg.pngj.pixels.CompressorStreamParallelDeflater;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;

public abstract class PixelsWriter {
    private static final int IDAT_MAX_SIZE_DEFAULT = 32000;
    protected final ImageInfo imgInfo;
    protected final int buflen;
    protected final int bytesPixel;
    protected final int bytesRow;
    private CompressorStream compressorStream;
    protected int deflaterCompLevel = 6;
    protected int deflaterStrategy = 0;
    protected ExecutorService deflaterParallelExecutor;
    protected boolean initdone = false;
    protected FilterType filterType;
    private int[] filtersUsed = new int[5];
    private OutputStream os;
    private int idatMaxSize = 32000;
    protected int currentRow;

    public PixelsWriter(ImageInfo imageInfo) {
        this.imgInfo = imageInfo;
        this.bytesRow = imageInfo.bytesPerRow;
        this.buflen = this.bytesRow + 1;
        this.bytesPixel = imageInfo.bytesPixel;
        this.currentRow = -1;
        this.filterType = FilterType.FILTER_DEFAULT;
    }

    public final void processRow(byte[] byArray) {
        if (!this.initdone) {
            this.init();
        }
        ++this.currentRow;
        this.filterAndWrite(byArray);
    }

    protected void sendToCompressedStream(byte[] byArray) {
        this.compressorStream.write(byArray, 0, byArray.length);
        byte by = byArray[0];
        this.filtersUsed[by] = this.filtersUsed[by] + 1;
    }

    protected abstract void filterAndWrite(byte[] var1);

    protected final byte[] filterRowWithFilterType(FilterType filterType, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (filterType == FilterType.FILTER_NONE) {
            byArray3 = byArray;
        }
        byArray3[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                break;
            }
            case FILTER_PAETH: {
                int n;
                for (n = 1; n <= this.bytesPixel; ++n) {
                    byArray3[n] = (byte)PngHelperInternal.filterRowPaeth(byArray[n], 0, byArray2[n] & 0xFF, 0);
                }
                int n2 = 1;
                n = this.bytesPixel + 1;
                while (n <= this.bytesRow) {
                    byArray3[n] = (byte)PngHelperInternal.filterRowPaeth(byArray[n], byArray[n2] & 0xFF, byArray2[n] & 0xFF, byArray2[n2] & 0xFF);
                    ++n;
                    ++n2;
                }
                break;
            }
            case FILTER_SUB: {
                int n;
                for (n = 1; n <= this.bytesPixel; ++n) {
                    byArray3[n] = byArray[n];
                }
                int n3 = 1;
                n = this.bytesPixel + 1;
                while (n <= this.bytesRow) {
                    byArray3[n] = (byte)(byArray[n] - byArray[n3]);
                    ++n;
                    ++n3;
                }
                break;
            }
            case FILTER_AVERAGE: {
                int n;
                for (n = 1; n <= this.bytesPixel; ++n) {
                    byArray3[n] = (byte)(byArray[n] - (byArray2[n] & 0xFF) / 2);
                }
                int n4 = 1;
                n = this.bytesPixel + 1;
                while (n <= this.bytesRow) {
                    byArray3[n] = (byte)(byArray[n] - ((byArray2[n] & 0xFF) + (byArray[n4] & 0xFF)) / 2);
                    ++n;
                    ++n4;
                }
                break;
            }
            case FILTER_UP: {
                for (int i = 1; i <= this.bytesRow; ++i) {
                    byArray3[i] = (byte)(byArray[i] - byArray2[i]);
                }
                break;
            }
            default: {
                throw new PngjOutputException("Filter type not recognized: " + (Object)((Object)filterType));
            }
        }
        return byArray3;
    }

    public abstract byte[] getRowb();

    protected final void init() {
        if (!this.initdone) {
            this.initParams();
            this.initdone = true;
        }
    }

    protected void initParams() {
        IdatChunkWriter idatChunkWriter = new IdatChunkWriter(this.os, this.idatMaxSize);
        if (this.compressorStream == null) {
            this.compressorStream = this.deflaterParallelExecutor != null ? new CompressorStreamParallelDeflater(idatChunkWriter, this.buflen, this.imgInfo.getTotalRawBytes(), this.deflaterParallelExecutor, this.deflaterCompLevel, this.deflaterStrategy) : new CompressorStreamDeflater(idatChunkWriter, this.buflen, this.imgInfo.getTotalRawBytes(), this.deflaterCompLevel, this.deflaterStrategy);
        }
    }

    public void close() {
        if (this.compressorStream != null) {
            this.compressorStream.close();
        }
    }

    public void setDeflaterStrategy(Integer n) {
        this.deflaterStrategy = n;
    }

    public void setDeflaterCompLevel(Integer n) {
        this.deflaterCompLevel = n;
    }

    public Integer getDeflaterCompLevel() {
        return this.deflaterCompLevel;
    }

    public void setDeflaterParallelExecutor(ExecutorService executorService) {
        this.deflaterParallelExecutor = executorService;
    }

    public ExecutorService getDeflaterParallelExecutor() {
        return this.deflaterParallelExecutor;
    }

    public final void setOs(OutputStream outputStream) {
        this.os = outputStream;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public final FilterType getFilterType() {
        return this.filterType;
    }

    public final void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public double getCompression() {
        return this.compressorStream.isDone() ? this.compressorStream.getCompressionRatio() : 1.0;
    }

    public void setCompressorStream(CompressorStream compressorStream) {
        this.compressorStream = compressorStream;
    }

    public long getTotalBytesToWrite() {
        return this.imgInfo.getTotalRawBytes();
    }

    public boolean isDone() {
        return this.currentRow == this.imgInfo.rows - 1;
    }

    protected FilterType getDefaultFilter() {
        if (this.imgInfo.indexed || this.imgInfo.bitDepth < 8) {
            return FilterType.FILTER_NONE;
        }
        if (this.imgInfo.getTotalPixels() < 1024L) {
            return FilterType.FILTER_NONE;
        }
        if (this.imgInfo.rows == 1) {
            return FilterType.FILTER_SUB;
        }
        if (this.imgInfo.cols == 1) {
            return FilterType.FILTER_UP;
        }
        return FilterType.FILTER_PAETH;
    }

    public final String getFiltersUsed() {
        return String.format("%d,%d,%d,%d,%d", (int)((double)this.filtersUsed[0] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[1] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[2] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[3] * 100.0 / (double)this.imgInfo.rows + 0.5), (int)((double)this.filtersUsed[4] * 100.0 / (double)this.imgInfo.rows + 0.5));
    }

    public void setIdatMaxSize(int n) {
        this.idatMaxSize = n;
    }
}

