/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IdatChunkWriter;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import java.util.zip.Deflater;

public class CompressorStreamDeflater
extends CompressorStream {
    protected Deflater deflater;
    protected byte[] buf1;
    protected boolean deflaterIsOwn = true;

    public CompressorStreamDeflater(IdatChunkWriter idatChunkWriter, int n, long l, Deflater deflater) {
        super(idatChunkWriter, n, l);
        this.deflater = deflater == null ? new Deflater() : deflater;
        this.deflaterIsOwn = deflater == null;
    }

    public CompressorStreamDeflater(IdatChunkWriter idatChunkWriter, int n, long l) {
        this(idatChunkWriter, n, l, null);
    }

    public CompressorStreamDeflater(IdatChunkWriter idatChunkWriter, int n, long l, int n2, int n3) {
        this(idatChunkWriter, n, l, new Deflater(n2));
        this.deflaterIsOwn = true;
        this.deflater.setStrategy(n3);
    }

    @Override
    public void mywrite(byte[] byArray, int n, int n2) {
        if (this.deflater.finished() || this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.deflater.setInput(byArray, n, n2);
        this.bytesIn += (long)n2;
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    protected void deflate() {
        int n;
        int n2;
        byte[] byArray;
        if (this.idatChunkWriter != null) {
            byArray = this.idatChunkWriter.getBuf();
            n2 = this.idatChunkWriter.getOffset();
            n = this.idatChunkWriter.getAvailLen();
        } else {
            if (this.buf1 == null) {
                this.buf1 = new byte[4096];
            }
            byArray = this.buf1;
            n2 = 0;
            n = this.buf1.length;
        }
        int n3 = this.deflater.deflate(byArray, n2, n);
        if (n3 > 0) {
            if (this.idatChunkWriter != null) {
                this.idatChunkWriter.incrementOffset(n3);
            }
            this.bytesOut += (long)n3;
        }
    }

    @Override
    public void done() {
        if (this.done) {
            return;
        }
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
        this.done = true;
        if (this.idatChunkWriter != null) {
            this.idatChunkWriter.close();
        }
    }

    @Override
    public void close() {
        this.done();
        try {
            if (this.deflaterIsOwn) {
                this.deflater.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public void reset() {
        this.deflater.reset();
        super.reset();
    }
}

