/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngChunkZTXT
extends PngChunkTextVar {
    public static final String ID = "zTXt";

    public PngChunkZTXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key == null || this.key.trim().length() == 0) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(ChunkHelper.toBytesLatin1(this.key));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byte[] byArray = ChunkHelper.compressBytes(ChunkHelper.toBytesLatin1(this.val), true);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n;
        int n2 = -1;
        for (n = 0; n < chunkRaw.data.length; ++n) {
            if (chunkRaw.data[n] != 0) continue;
            n2 = n;
            break;
        }
        if (n2 < 0 || n2 > chunkRaw.data.length - 2) {
            throw new PngjException("bad zTXt chunk: no separator found");
        }
        this.key = ChunkHelper.toStringLatin1(chunkRaw.data, 0, n2);
        n = chunkRaw.data[n2 + 1];
        if (n != 0) {
            throw new PngjException("bad zTXt chunk: unknown compression method");
        }
        byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n2 + 2, chunkRaw.data.length - n2 - 2, false);
        this.val = ChunkHelper.toStringLatin1(byArray);
    }
}

