/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;

public class PngChunkTEXT
extends PngChunkTextVar {
    public static final String ID = "tEXt";

    public PngChunkTEXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunkTEXT(ImageInfo imageInfo, String string, String string2) {
        super(ID, imageInfo);
        this.setKeyVal(string, string2);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key == null || this.key.trim().length() == 0) {
            throw new PngjException("Text chunk key must be non empty");
        }
        byte[] byArray = ChunkHelper.toBytesLatin1(this.key + "\u0000" + this.val);
        ChunkRaw chunkRaw = this.createEmptyChunk(byArray.length, false);
        chunkRaw.data = byArray;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n;
        for (n = 0; n < chunkRaw.data.length && chunkRaw.data[n] != 0; ++n) {
        }
        this.key = ChunkHelper.toStringLatin1(chunkRaw.data, 0, n);
        this.val = ++n < chunkRaw.data.length ? ChunkHelper.toStringLatin1(chunkRaw.data, n, chunkRaw.data.length - n) : "";
    }
}

