/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkPLTE
extends PngChunkSingle {
    public static final String ID = "PLTE";
    private int nentries = 0;
    private int[] entries;

    public PngChunkPLTE(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        int n = 3 * this.nentries;
        int[] nArray = new int[3];
        ChunkRaw chunkRaw = this.createEmptyChunk(n, true);
        int n2 = 0;
        for (int i = 0; i < this.nentries; ++i) {
            this.getEntryRgb(i, nArray);
            chunkRaw.data[n2++] = (byte)nArray[0];
            chunkRaw.data[n2++] = (byte)nArray[1];
            chunkRaw.data[n2++] = (byte)nArray[2];
        }
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        this.setNentries(chunkRaw.len / 3);
        int n = 0;
        for (int i = 0; i < this.nentries; ++i) {
            this.setEntry(i, chunkRaw.data[n++] & 0xFF, chunkRaw.data[n++] & 0xFF, chunkRaw.data[n++] & 0xFF);
        }
    }

    public void setNentries(int n) {
        this.nentries = n;
        if (this.nentries < 1 || this.nentries > 256) {
            throw new PngjException("invalid pallette - nentries=" + this.nentries);
        }
        if (this.entries == null || this.entries.length != this.nentries) {
            this.entries = new int[this.nentries];
        }
    }

    public int getNentries() {
        return this.nentries;
    }

    public void setEntry(int n, int n2, int n3, int n4) {
        this.entries[n] = n2 << 16 | n3 << 8 | n4;
    }

    public int getEntry(int n) {
        return this.entries[n];
    }

    public void getEntryRgb(int n, int[] nArray) {
        this.getEntryRgb(n, nArray, 0);
    }

    public void getEntryRgb(int n, int[] nArray, int n2) {
        int n3 = this.entries[n];
        nArray[n2 + 0] = (n3 & 0xFF0000) >> 16;
        nArray[n2 + 1] = (n3 & 0xFF00) >> 8;
        nArray[n2 + 2] = n3 & 0xFF;
    }

    public int minBitDepth() {
        if (this.nentries <= 2) {
            return 1;
        }
        if (this.nentries <= 4) {
            return 2;
        }
        if (this.nentries <= 16) {
            return 4;
        }
        return 8;
    }
}

