/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo imageInfo) {
        super(ID, imageInfo);
        if (imageInfo != null) {
            this.fillFromInfo(imageInfo);
        }
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int n = 0;
        PngHelperInternal.writeInt4tobytes(this.cols, chunkRaw.data, n);
        PngHelperInternal.writeInt4tobytes(this.rows, chunkRaw.data, n += 4);
        n += 4;
        chunkRaw.data[n++] = (byte)this.bitspc;
        chunkRaw.data[n++] = (byte)this.colormodel;
        chunkRaw.data[n++] = (byte)this.compmeth;
        chunkRaw.data[n++] = (byte)this.filmeth;
        chunkRaw.data[n++] = (byte)this.interlaced;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 13) {
            throw new PngjException("Bad IDHR len " + chunkRaw.len);
        }
        ByteArrayInputStream byteArrayInputStream = chunkRaw.getAsByteStream();
        this.cols = PngHelperInternal.readInt4(byteArrayInputStream);
        this.rows = PngHelperInternal.readInt4(byteArrayInputStream);
        this.bitspc = PngHelperInternal.readByte(byteArrayInputStream);
        this.colormodel = PngHelperInternal.readByte(byteArrayInputStream);
        this.compmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.filmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.interlaced = PngHelperInternal.readByte(byteArrayInputStream);
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int n) {
        this.bitspc = n;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int n) {
        this.colormodel = n;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int n) {
        this.compmeth = n;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int n) {
        this.filmeth = n;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int n) {
        this.interlaced = n;
    }

    public boolean isInterlaced() {
        return this.getInterlaced() == 1;
    }

    public void fillFromInfo(ImageInfo imageInfo) {
        this.setCols(this.imgInfo.cols);
        this.setRows(this.imgInfo.rows);
        this.setBitspc(this.imgInfo.bitDepth);
        int n = 0;
        if (this.imgInfo.alpha) {
            n += 4;
        }
        if (this.imgInfo.indexed) {
            ++n;
        }
        if (!this.imgInfo.greyscale) {
            n += 2;
        }
        this.setColormodel(n);
        this.setCompmeth(0);
        this.setFilmeth(0);
        this.setInterlaced(0);
    }

    public ImageInfo createImageInfo() {
        this.check();
        boolean bl = (this.getColormodel() & 4) != 0;
        boolean bl2 = (this.getColormodel() & 1) != 0;
        boolean bl3 = this.getColormodel() == 0 || this.getColormodel() == 4;
        return new ImageInfo(this.getCols(), this.getRows(), this.getBitspc(), bl, bl3, bl2);
    }

    public void check() {
        if (this.cols < 1 || this.rows < 1 || this.compmeth != 0 || this.filmeth != 0) {
            throw new PngjInputException("bad IHDR: col/row/compmethod/filmethod invalid");
        }
        if (this.bitspc != 1 && this.bitspc != 2 && this.bitspc != 4 && this.bitspc != 8 && this.bitspc != 16) {
            throw new PngjInputException("bad IHDR: bitdepth invalid");
        }
        if (this.interlaced < 0 || this.interlaced > 1) {
            throw new PngjInputException("bad IHDR: interlace invalid");
        }
        switch (this.colormodel) {
            case 0: {
                break;
            }
            case 3: {
                if (this.bitspc != 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            case 2: 
            case 4: 
            case 6: {
                if (this.bitspc == 8 || this.bitspc == 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            default: {
                throw new PngjInputException("bad IHDR: invalid colormodel");
            }
        }
    }
}

