/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkICCP
extends PngChunkSingle {
    public static final String ID = "iCCP";
    private String profileName;
    private byte[] compressedProfile;

    public PngChunkICCP(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(this.profileName.length() + this.compressedProfile.length + 2, true);
        System.arraycopy(ChunkHelper.toBytesLatin1(this.profileName), 0, chunkRaw.data, 0, this.profileName.length());
        chunkRaw.data[this.profileName.length()] = 0;
        chunkRaw.data[this.profileName.length() + 1] = 0;
        System.arraycopy(this.compressedProfile, 0, chunkRaw.data, this.profileName.length() + 2, this.compressedProfile.length);
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n = ChunkHelper.posNullByte(chunkRaw.data);
        this.profileName = ChunkHelper.toStringLatin1(chunkRaw.data, 0, n);
        int n2 = chunkRaw.data[n + 1] & 0xFF;
        if (n2 != 0) {
            throw new PngjException("bad compression for ChunkTypeICCP");
        }
        int n3 = chunkRaw.data.length - (n + 2);
        this.compressedProfile = new byte[n3];
        System.arraycopy(chunkRaw.data, n + 2, this.compressedProfile, 0, n3);
    }

    public void setProfileNameAndContent(String string, byte[] byArray) {
        this.profileName = string;
        this.compressedProfile = ChunkHelper.compressBytes(byArray, true);
    }

    public void setProfileNameAndContent(String string, String string2) {
        this.setProfileNameAndContent(string, ChunkHelper.toBytesLatin1(string2));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public byte[] getProfile() {
        return ChunkHelper.compressBytes(this.compressedProfile, false);
    }

    public String getProfileAsString() {
        return ChunkHelper.toStringLatin1(this.getProfile());
    }
}

