/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.OutputStream;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    protected ChunkRaw raw;
    private boolean priority = false;
    protected int chunkGroup = -1;

    public PngChunk(String string, ImageInfo imageInfo) {
        this.id = string;
        this.imgInfo = imageInfo;
        this.crit = ChunkHelper.isCritical(string);
        this.pub = ChunkHelper.isPublic(string);
        this.safe = ChunkHelper.isSafeToCopy(string);
    }

    protected final ChunkRaw createEmptyChunk(int n, boolean bl) {
        ChunkRaw chunkRaw = new ChunkRaw(n, ChunkHelper.toBytesLatin1(this.id), bl);
        return chunkRaw;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    final void setChunkGroup(int n) {
        this.chunkGroup = n;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public void setPriority(boolean bl) {
        this.priority = bl;
    }

    final void write(OutputStream outputStream) {
        if (this.raw == null || this.raw.data == null) {
            this.raw = this.createRawChunk();
        }
        if (this.raw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        this.raw.writeChunk(outputStream);
    }

    public abstract ChunkRaw createRawChunk();

    protected abstract void parseFromRaw(ChunkRaw var1);

    protected abstract boolean allowsMultiple();

    public ChunkRaw getRaw() {
        return this.raw;
    }

    void setRaw(ChunkRaw chunkRaw) {
        this.raw = chunkRaw;
    }

    public int getLen() {
        return this.raw != null ? this.raw.len : -1;
    }

    public long getOffset() {
        return this.raw != null ? this.raw.getOffset() : -1L;
    }

    public void invalidateRawData() {
        this.raw = null;
    }

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.getLen() + " offset=" + this.getOffset() + ")";
    }

    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED,
        BEFORE_IDAT,
        AFTER_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT || this == AFTER_PLTE_BEFORE_IDAT_PLTE_REQUIRED;
        }

        public boolean mustGoAfterIDAT() {
            return this == AFTER_IDAT;
        }

        public boolean isOk(int n, boolean bl) {
            if (this == NONE) {
                return true;
            }
            if (this == BEFORE_IDAT) {
                return n < 4;
            }
            if (this == BEFORE_PLTE_AND_IDAT) {
                return n < 2;
            }
            if (this == AFTER_PLTE_BEFORE_IDAT) {
                return bl ? n < 4 : n < 4 && n > 2;
            }
            if (this == AFTER_IDAT) {
                return n > 4;
            }
            return false;
        }
    }
}

