/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;

public class ChunkCopyBehaviour {
    public static final int COPY_NONE = 0;
    public static final int COPY_PALETTE = 1;
    public static final int COPY_ALL_SAFE = 4;
    public static final int COPY_ALL = 8;
    public static final int COPY_PHYS = 16;
    public static final int COPY_TEXTUAL = 32;
    public static final int COPY_TRANSPARENCY = 64;
    public static final int COPY_UNKNOWN = 128;
    public static final int COPY_ALMOSTALL = 256;

    private static boolean maskMatch(int n, int n2) {
        return (n & n2) != 0;
    }

    public static ChunkPredicate createPredicate(final int n, final ImageInfo imageInfo) {
        return new ChunkPredicate(){

            @Override
            public boolean match(PngChunk pngChunk) {
                if (pngChunk.crit) {
                    if (pngChunk.id.equals("PLTE")) {
                        if (imageInfo.indexed && ChunkCopyBehaviour.maskMatch(n, 1)) {
                            return true;
                        }
                        if (!imageInfo.greyscale && ChunkCopyBehaviour.maskMatch(n, 8)) {
                            return true;
                        }
                    }
                } else {
                    boolean bl = pngChunk instanceof PngChunkTextVar;
                    boolean bl2 = pngChunk.safe;
                    if (ChunkCopyBehaviour.maskMatch(n, 8)) {
                        return true;
                    }
                    if (bl2 && ChunkCopyBehaviour.maskMatch(n, 4)) {
                        return true;
                    }
                    if (pngChunk.id.equals("tRNS") && ChunkCopyBehaviour.maskMatch(n, 64)) {
                        return true;
                    }
                    if (pngChunk.id.equals("pHYs") && ChunkCopyBehaviour.maskMatch(n, 16)) {
                        return true;
                    }
                    if (bl && ChunkCopyBehaviour.maskMatch(n, 32)) {
                        return true;
                    }
                    if (!(!ChunkCopyBehaviour.maskMatch(n, 256) || ChunkHelper.isUnknown(pngChunk) || bl || pngChunk.id.equals("hIST") || pngChunk.id.equals("tIME"))) {
                        return true;
                    }
                    if (ChunkCopyBehaviour.maskMatch(n, 128) && ChunkHelper.isUnknown(pngChunk)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

