/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjException;
import java.util.zip.Checksum;

public class ImageInfo {
    public static final int MAX_COLS_ROW = 0x1000000;
    public final int cols;
    public final int rows;
    public final int bitDepth;
    public final int channels;
    public final boolean alpha;
    public final boolean greyscale;
    public final boolean indexed;
    public final boolean packed;
    public final int bitspPixel;
    public final int bytesPixel;
    public final int bytesPerRow;
    public final int samplesPerRow;
    public final int samplesPerRowPacked;
    private long totalPixels = -1L;
    private long totalRawBytes = -1L;

    public ImageInfo(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, false, false);
    }

    public ImageInfo(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.cols = n;
        this.rows = n2;
        this.alpha = bl;
        this.indexed = bl3;
        this.greyscale = bl2;
        if (this.greyscale && bl3) {
            throw new PngjException("palette and greyscale are mutually exclusive");
        }
        this.channels = bl2 || bl3 ? (bl ? 2 : 1) : (bl ? 4 : 3);
        this.bitDepth = n3;
        this.packed = n3 < 8;
        this.bitspPixel = this.channels * this.bitDepth;
        this.bytesPixel = (this.bitspPixel + 7) / 8;
        this.bytesPerRow = (this.bitspPixel * n + 7) / 8;
        this.samplesPerRow = this.channels * this.cols;
        this.samplesPerRowPacked = this.packed ? this.bytesPerRow : this.samplesPerRow;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (n < 1 || n > 0x1000000) {
            throw new PngjException("invalid cols=" + n + " ???");
        }
        if (n2 < 1 || n2 > 0x1000000) {
            throw new PngjException("invalid rows=" + n2 + " ???");
        }
        if (this.samplesPerRow < 1) {
            throw new PngjException("invalid image parameters (overflow?)");
        }
    }

    public ImageInfo withSize(int n, int n2) {
        return new ImageInfo(n > 0 ? n : this.cols, n2 > 0 ? n2 : this.rows, this.bitDepth, this.alpha, this.greyscale, this.indexed);
    }

    public long getTotalPixels() {
        if (this.totalPixels < 0L) {
            this.totalPixels = (long)this.cols * (long)this.rows;
        }
        return this.totalPixels;
    }

    public long getTotalRawBytes() {
        if (this.totalRawBytes < 0L) {
            this.totalRawBytes = (long)(this.bytesPerRow + 1) * (long)this.rows;
        }
        return this.totalRawBytes;
    }

    public String toString() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + "]";
    }

    public String toStringBrief() {
        return String.valueOf(this.cols) + "x" + this.rows + (this.bitDepth != 8 ? "d" + this.bitDepth : "") + (this.alpha ? "a" : "") + (this.indexed ? "p" : "") + (this.greyscale ? "g" : "");
    }

    public String toStringDetail() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", bitspPixel=" + this.bitspPixel + ", bytesPixel=" + this.bytesPixel + ", bytesPerRow=" + this.bytesPerRow + ", samplesPerRow=" + this.samplesPerRow + ", samplesPerRowP=" + this.samplesPerRowPacked + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + ", packed=" + this.packed + "]";
    }

    void updateCrc(Checksum checksum) {
        checksum.update((byte)this.rows);
        checksum.update((byte)(this.rows >> 8));
        checksum.update((byte)(this.rows >> 16));
        checksum.update((byte)this.cols);
        checksum.update((byte)(this.cols >> 8));
        checksum.update((byte)(this.cols >> 16));
        checksum.update((byte)this.bitDepth);
        checksum.update((byte)(this.indexed ? 1 : 2));
        checksum.update((byte)(this.greyscale ? 3 : 4));
        checksum.update((byte)(this.alpha ? 3 : 4));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.alpha ? 1231 : 1237);
        n = 31 * n + this.bitDepth;
        n = 31 * n + this.cols;
        n = 31 * n + (this.greyscale ? 1231 : 1237);
        n = 31 * n + (this.indexed ? 1231 : 1237);
        n = 31 * n + this.rows;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)object;
        if (this.alpha != imageInfo.alpha) {
            return false;
        }
        if (this.bitDepth != imageInfo.bitDepth) {
            return false;
        }
        if (this.cols != imageInfo.cols) {
            return false;
        }
        if (this.greyscale != imageInfo.greyscale) {
            return false;
        }
        if (this.indexed != imageInfo.indexed) {
            return false;
        }
        return this.rows == imageInfo.rows;
    }
}

