/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;

public abstract class DeflatedChunkReader
extends ChunkReader {
    protected final DeflatedChunksSet deflatedChunksSet;
    protected boolean alsoBuffer = false;
    protected boolean skipBytes = false;
    protected byte[] skippedBytes;
    protected int seqNumExpected = -1;

    public DeflatedChunkReader(int n, String string, boolean bl, long l, DeflatedChunksSet deflatedChunksSet) {
        super(n, string, l, ChunkReader.ChunkReaderMode.PROCESS);
        this.deflatedChunksSet = deflatedChunksSet;
        if (string.equals("fdAT")) {
            this.skipBytes = true;
            this.skippedBytes = new byte[4];
        }
        deflatedChunksSet.appendNewChunk(this);
    }

    @Override
    protected void processData(int n, byte[] byArray, int n2, int n3) {
        if (this.skipBytes && n < 4) {
            int n4 = n;
            while (n4 < 4 && n3 > 0) {
                this.skippedBytes[n4] = byArray[n2];
                ++n4;
                ++n2;
                --n3;
            }
        }
        if (n3 > 0) {
            this.deflatedChunksSet.processBytes(byArray, n2, n3);
            if (this.alsoBuffer) {
                System.arraycopy(byArray, n2, this.getChunkRaw().data, this.read, n3);
            }
        }
    }

    @Override
    protected void chunkDone() {
        int n;
        if (this.skipBytes && this.getChunkRaw().id.equals("fdAT") && this.seqNumExpected >= 0 && (n = PngHelperInternal.readInt4fromBytes(this.skippedBytes, 0)) != this.seqNumExpected) {
            throw new PngjInputException("bad chunk sequence for fDAT chunk " + n + " expected " + this.seqNumExpected);
        }
    }

    @Override
    public boolean isFromDeflatedSet() {
        return true;
    }

    public void setAlsoBuffer() {
        if (this.read > 0) {
            throw new RuntimeException("too late");
        }
        this.alsoBuffer = true;
        this.getChunkRaw().allocData();
    }

    public void setSeqNumExpected(int n) {
        this.seqNumExpected = n;
    }
}

