/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

class ShapeStrokeParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "c", "w", "o", "lc", "lj", "ml", "hd", "d");
    private static final JsonReader.Options DASH_PATTERN_NAMES = JsonReader.Options.of("n", "v");

    private ShapeStrokeParser() {
    }

    static ShapeStroke parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableColorValue color = null;
        AnimatableFloatValue width = null;
        AnimatableIntegerValue opacity = null;
        ShapeStroke.LineCapType capType = null;
        ShapeStroke.LineJoinType joinType = null;
        AnimatableFloatValue offset = null;
        float miterLimit = 0.0f;
        boolean hidden = false;
        ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
        block24: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block24;
                }
                case 1: {
                    color = AnimatableValueParser.parseColor(reader, composition);
                    continue block24;
                }
                case 2: {
                    width = AnimatableValueParser.parseFloat(reader, composition);
                    continue block24;
                }
                case 3: {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block24;
                }
                case 4: {
                    capType = ShapeStroke.LineCapType.values()[reader.nextInt() - 1];
                    continue block24;
                }
                case 5: {
                    joinType = ShapeStroke.LineJoinType.values()[reader.nextInt() - 1];
                    continue block24;
                }
                case 6: {
                    miterLimit = (float)reader.nextDouble();
                    continue block24;
                }
                case 7: {
                    hidden = reader.nextBoolean();
                    continue block24;
                }
                case 8: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String n = null;
                        AnimatableFloatValue val = null;
                        reader.beginObject();
                        block26: while (reader.hasNext()) {
                            switch (reader.selectName(DASH_PATTERN_NAMES)) {
                                case 0: {
                                    n = reader.nextString();
                                    continue block26;
                                }
                                case 1: {
                                    val = AnimatableValueParser.parseFloat(reader, composition);
                                    continue block26;
                                }
                            }
                            reader.skipName();
                            reader.skipValue();
                        }
                        reader.endObject();
                        switch (n) {
                            case "o": {
                                offset = val;
                                break;
                            }
                            case "d": 
                            case "g": {
                                composition.setHasDashPattern(true);
                                lineDashPattern.add(val);
                            }
                        }
                    }
                    reader.endArray();
                    if (lineDashPattern.size() != 1) continue block24;
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                    continue block24;
                }
            }
            reader.skipValue();
        }
        opacity = opacity == null ? new AnimatableIntegerValue(Collections.singletonList(new Keyframe<Integer>(100))) : opacity;
        capType = capType == null ? ShapeStroke.LineCapType.BUTT : capType;
        joinType = joinType == null ? ShapeStroke.LineJoinType.MITER : joinType;
        return new ShapeStroke(name, offset, lineDashPattern, color, opacity, width, capType, joinType, miterLimit, hidden);
    }
}

