/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.DropShadowEffect;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

public class DropShadowEffectParser {
    private static final JsonReader.Options DROP_SHADOW_EFFECT_NAMES = JsonReader.Options.of("ef");
    private static final JsonReader.Options INNER_EFFECT_NAMES = JsonReader.Options.of("nm", "v");
    private AnimatableColorValue color;
    private AnimatableFloatValue opacity;
    private AnimatableFloatValue direction;
    private AnimatableFloatValue distance;
    private AnimatableFloatValue radius;

    @Nullable
    DropShadowEffect parse(JsonReader reader, LottieComposition composition) throws IOException {
        block3: while (reader.hasNext()) {
            switch (reader.selectName(DROP_SHADOW_EFFECT_NAMES)) {
                case 0: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        this.maybeParseInnerEffect(reader, composition);
                    }
                    reader.endArray();
                    continue block3;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        if (this.color != null && this.opacity != null && this.direction != null && this.distance != null && this.radius != null) {
            return new DropShadowEffect(this.color, this.opacity, this.direction, this.distance, this.radius);
        }
        return null;
    }

    private void maybeParseInnerEffect(JsonReader reader, LottieComposition composition) throws IOException {
        String currentEffectName = "";
        reader.beginObject();
        block18: while (reader.hasNext()) {
            switch (reader.selectName(INNER_EFFECT_NAMES)) {
                case 0: {
                    currentEffectName = reader.nextString();
                    continue block18;
                }
                case 1: {
                    switch (currentEffectName) {
                        case "Shadow Color": {
                            this.color = AnimatableValueParser.parseColor(reader, composition);
                            continue block18;
                        }
                        case "Opacity": {
                            this.opacity = AnimatableValueParser.parseFloat(reader, composition, false);
                            continue block18;
                        }
                        case "Direction": {
                            this.direction = AnimatableValueParser.parseFloat(reader, composition, false);
                            continue block18;
                        }
                        case "Distance": {
                            this.distance = AnimatableValueParser.parseFloat(reader, composition);
                            continue block18;
                        }
                        case "Softness": {
                            this.radius = AnimatableValueParser.parseFloat(reader, composition);
                            continue block18;
                        }
                    }
                    reader.skipValue();
                    continue block18;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
    }
}

