/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.ScaleXY;
import java.io.IOException;

public class AnimatableTransformParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("a", "p", "s", "rz", "r", "o", "so", "eo", "sk", "sa", "rx", "ry");
    private static final JsonReader.Options ANIMATABLE_NAMES = JsonReader.Options.of("k");

    private AnimatableTransformParser() {
    }

    public static AnimatableTransform parse(JsonReader reader, LottieComposition composition) throws IOException {
        boolean isObject;
        AnimatablePathValue anchorPoint = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatableScaleValue scale = null;
        AnimatableFloatValue rotation = null;
        AnimatableIntegerValue opacity = null;
        AnimatableFloatValue startOpacity = null;
        AnimatableFloatValue endOpacity = null;
        AnimatableFloatValue skew = null;
        AnimatableFloatValue skewAngle = null;
        AnimatableFloatValue rotationX = null;
        AnimatableFloatValue rotationY = null;
        AnimatableFloatValue rotationZ = null;
        boolean bl = isObject = reader.peek() == JsonReader.Token.BEGIN_OBJECT;
        if (isObject) {
            reader.beginObject();
        }
        block17: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    reader.beginObject();
                    block18: while (reader.hasNext()) {
                        switch (reader.selectName(ANIMATABLE_NAMES)) {
                            case 0: {
                                anchorPoint = AnimatablePathValueParser.parse(reader, composition);
                                continue block18;
                            }
                        }
                        reader.skipName();
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block17;
                }
                case 1: {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block17;
                }
                case 2: {
                    scale = AnimatableValueParser.parseScale(reader, composition);
                    continue block17;
                }
                case 3: {
                    rotationZ = AnimatableValueParser.parseFloat(reader, composition, false);
                    AnimatableTransformParser.ensureValidRotationKeyframes(rotationZ, composition);
                    continue block17;
                }
                case 4: {
                    rotation = AnimatableValueParser.parseFloat(reader, composition, false);
                    AnimatableTransformParser.ensureValidRotationKeyframes(rotation, composition);
                    continue block17;
                }
                case 5: {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block17;
                }
                case 6: {
                    startOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block17;
                }
                case 7: {
                    endOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block17;
                }
                case 8: {
                    skew = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block17;
                }
                case 9: {
                    skewAngle = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block17;
                }
                case 10: {
                    rotationX = AnimatableValueParser.parseFloat(reader, composition, false);
                    AnimatableTransformParser.ensureValidRotationKeyframes(rotationX, composition);
                    continue block17;
                }
                case 11: {
                    rotationY = AnimatableValueParser.parseFloat(reader, composition, false);
                    AnimatableTransformParser.ensureValidRotationKeyframes(rotationY, composition);
                    continue block17;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        if (isObject) {
            reader.endObject();
        }
        if (AnimatableTransformParser.isAnchorPointIdentity(anchorPoint)) {
            anchorPoint = null;
        }
        if (AnimatableTransformParser.isPositionIdentity(position)) {
            position = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(rotation)) {
            rotation = null;
        }
        if (AnimatableTransformParser.isScaleIdentity(scale)) {
            scale = null;
        }
        if (AnimatableTransformParser.isSkewIdentity(skew)) {
            skew = null;
        }
        if (AnimatableTransformParser.isSkewAngleIdentity(skewAngle)) {
            skewAngle = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(rotationX)) {
            rotationX = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(rotationY)) {
            rotationY = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(rotationZ)) {
            rotationZ = null;
        }
        return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity, skew, skewAngle, rotationX, rotationY, rotationZ);
    }

    private static boolean isAnchorPointIdentity(AnimatablePathValue anchorPoint) {
        return anchorPoint == null || anchorPoint.isStatic() && ((PointF)anchorPoint.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isPositionIdentity(AnimatableValue<PointF, PointF> position) {
        return position == null || !(position instanceof AnimatableSplitDimensionPathValue) && position.isStatic() && ((PointF)position.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isRotationIdentity(AnimatableFloatValue rotation) {
        return rotation == null || rotation.isStatic() && ((Float)((Keyframe)rotation.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isScaleIdentity(AnimatableScaleValue scale) {
        return scale == null || scale.isStatic() && ((ScaleXY)((Keyframe)scale.getKeyframes().get((int)0)).startValue).equals(1.0f, 1.0f);
    }

    private static boolean isSkewIdentity(AnimatableFloatValue skew) {
        return skew == null || skew.isStatic() && ((Float)((Keyframe)skew.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isSkewAngleIdentity(AnimatableFloatValue skewAngle) {
        return skewAngle == null || skewAngle.isStatic() && ((Float)((Keyframe)skewAngle.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static void ensureValidRotationKeyframes(AnimatableFloatValue rotation, LottieComposition composition) {
        if (rotation.getKeyframes().isEmpty()) {
            rotation.getKeyframes().add(new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(composition.getEndFrame())));
        } else if (((Keyframe)rotation.getKeyframes().get((int)0)).startValue == null) {
            rotation.getKeyframes().set(0, new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(composition.getEndFrame())));
        }
    }
}

