/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.AsyncUpdates;
import com.airbnb.lottie.configurations.reducemotion.ReducedMotionOption;
import com.airbnb.lottie.configurations.reducemotion.SystemReducedMotionOption;
import com.airbnb.lottie.network.LottieNetworkCacheProvider;
import com.airbnb.lottie.network.LottieNetworkFetcher;
import java.io.File;

public class LottieConfig {
    @Nullable
    final LottieNetworkFetcher networkFetcher;
    @Nullable
    final LottieNetworkCacheProvider cacheProvider;
    final boolean enableSystraceMarkers;
    final boolean enableNetworkCache;
    final boolean disablePathInterpolatorCache;
    final AsyncUpdates defaultAsyncUpdates;
    final ReducedMotionOption reducedMotionOption;

    private LottieConfig(@Nullable LottieNetworkFetcher networkFetcher, @Nullable LottieNetworkCacheProvider cacheProvider, boolean enableSystraceMarkers, boolean enableNetworkCache, boolean disablePathInterpolatorCache, AsyncUpdates defaultAsyncUpdates, ReducedMotionOption reducedMotionOption) {
        this.networkFetcher = networkFetcher;
        this.cacheProvider = cacheProvider;
        this.enableSystraceMarkers = enableSystraceMarkers;
        this.enableNetworkCache = enableNetworkCache;
        this.disablePathInterpolatorCache = disablePathInterpolatorCache;
        this.defaultAsyncUpdates = defaultAsyncUpdates;
        this.reducedMotionOption = reducedMotionOption;
    }

    public static final class Builder {
        @Nullable
        private LottieNetworkFetcher networkFetcher;
        @Nullable
        private LottieNetworkCacheProvider cacheProvider;
        private boolean enableSystraceMarkers = false;
        private boolean enableNetworkCache = true;
        private boolean disablePathInterpolatorCache = false;
        private AsyncUpdates defaultAsyncUpdates = AsyncUpdates.AUTOMATIC;
        private ReducedMotionOption reducedMotionOption = new SystemReducedMotionOption();

        @NonNull
        public Builder setNetworkFetcher(@NonNull LottieNetworkFetcher fetcher) {
            this.networkFetcher = fetcher;
            return this;
        }

        @NonNull
        public Builder setNetworkCacheDir(final @NonNull File file) {
            if (this.cacheProvider != null) {
                throw new IllegalStateException("There is already a cache provider!");
            }
            this.cacheProvider = new LottieNetworkCacheProvider(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                @NonNull
                public File getCacheDir() {
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("cache file must be a directory");
                    }
                    return file;
                }
            };
            return this;
        }

        @NonNull
        public Builder setNetworkCacheProvider(final @NonNull LottieNetworkCacheProvider fileCacheProvider) {
            if (this.cacheProvider != null) {
                throw new IllegalStateException("There is already a cache provider!");
            }
            this.cacheProvider = new LottieNetworkCacheProvider(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                @NonNull
                public File getCacheDir() {
                    File file = fileCacheProvider.getCacheDir();
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("cache file must be a directory");
                    }
                    return file;
                }
            };
            return this;
        }

        @NonNull
        public Builder setEnableSystraceMarkers(boolean enable) {
            this.enableSystraceMarkers = enable;
            return this;
        }

        @NonNull
        public Builder setEnableNetworkCache(boolean enable) {
            this.enableNetworkCache = enable;
            return this;
        }

        @NonNull
        public Builder setDisablePathInterpolatorCache(boolean disable) {
            this.disablePathInterpolatorCache = disable;
            return this;
        }

        @NonNull
        public Builder setDefaultAsyncUpdates(AsyncUpdates asyncUpdates) {
            this.defaultAsyncUpdates = asyncUpdates;
            return this;
        }

        @NonNull
        public Builder setReducedMotionOption(ReducedMotionOption reducedMotionOption) {
            this.reducedMotionOption = reducedMotionOption;
            return this;
        }

        @NonNull
        public LottieConfig build() {
            return new LottieConfig(this.networkFetcher, this.cacheProvider, this.enableSystraceMarkers, this.enableNetworkCache, this.disablePathInterpolatorCache, this.defaultAsyncUpdates, this.reducedMotionOption);
        }
    }
}

