/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.model.DocumentData;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

public class DocumentDataParser
implements ValueParser<DocumentData> {
    public static final DocumentDataParser INSTANCE = new DocumentDataParser();
    private static final JsonReader.Options NAMES = JsonReader.Options.of("t", "f", "s", "j", "tr", "lh", "ls", "fc", "sc", "sw", "of");

    private DocumentDataParser() {
    }

    @Override
    public DocumentData parse(JsonReader reader, float scale) throws IOException {
        String text = null;
        String fontName = null;
        double size = 0.0;
        DocumentData.Justification justification = DocumentData.Justification.CENTER;
        int tracking = 0;
        double lineHeight = 0.0;
        double baselineShift = 0.0;
        int fillColor = 0;
        int strokeColor = 0;
        double strokeWidth = 0.0;
        boolean strokeOverFill = true;
        reader.beginObject();
        block13: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    text = reader.nextString();
                    continue block13;
                }
                case 1: {
                    fontName = reader.nextString();
                    continue block13;
                }
                case 2: {
                    size = reader.nextDouble();
                    continue block13;
                }
                case 3: {
                    int justificationInt = reader.nextInt();
                    if (justificationInt > DocumentData.Justification.CENTER.ordinal() || justificationInt < 0) {
                        justification = DocumentData.Justification.CENTER;
                        continue block13;
                    }
                    justification = DocumentData.Justification.values()[justificationInt];
                    continue block13;
                }
                case 4: {
                    tracking = reader.nextInt();
                    continue block13;
                }
                case 5: {
                    lineHeight = reader.nextDouble();
                    continue block13;
                }
                case 6: {
                    baselineShift = reader.nextDouble();
                    continue block13;
                }
                case 7: {
                    fillColor = JsonUtils.jsonToColor(reader);
                    continue block13;
                }
                case 8: {
                    strokeColor = JsonUtils.jsonToColor(reader);
                    continue block13;
                }
                case 9: {
                    strokeWidth = reader.nextDouble();
                    continue block13;
                }
                case 10: {
                    strokeOverFill = reader.nextBoolean();
                    continue block13;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return new DocumentData(text, fontName, size, justification, tracking, lineHeight, baselineShift, fillColor, strokeColor, strokeWidth, strokeOverFill);
    }
}

