/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import androidx.annotation.ColorInt;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentData {
    public final String text;
    public final String fontName;
    public final double size;
    public final Justification justification;
    public final int tracking;
    public final double lineHeight;
    public final double baselineShift;
    @ColorInt
    public final int color;
    @ColorInt
    public final int strokeColor;
    public final double strokeWidth;
    public final boolean strokeOverFill;

    public DocumentData(String text, String fontName, double size, Justification justification, int tracking, double lineHeight, double baselineShift, @ColorInt int color, @ColorInt int strokeColor, double strokeWidth, boolean strokeOverFill) {
        this.text = text;
        this.fontName = fontName;
        this.size = size;
        this.justification = justification;
        this.tracking = tracking;
        this.lineHeight = lineHeight;
        this.baselineShift = baselineShift;
        this.color = color;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.strokeOverFill = strokeOverFill;
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.fontName.hashCode();
        result = (int)((double)(31 * result) + this.size);
        result = 31 * result + this.justification.ordinal();
        result = 31 * result + this.tracking;
        long temp = Double.doubleToLongBits(this.lineHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.color;
        return result;
    }

    public static enum Justification {
        LEFT_ALIGN,
        RIGHT_ALIGN,
        CENTER;

    }
}

