/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Path;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.GradientFill;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class GradientFillParser {
    private GradientFillParser() {
    }

    static GradientFill parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableGradientColorValue color = null;
        AnimatableIntegerValue opacity = null;
        GradientType gradientType = null;
        AnimatablePointValue startPoint = null;
        AnimatablePointValue endPoint = null;
        Path.FillType fillType = null;
        block26: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block26;
                }
                case "g": {
                    int points = -1;
                    reader.beginObject();
                    block27: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "p": {
                                points = reader.nextInt();
                                continue block27;
                            }
                            case "k": {
                                color = AnimatableValueParser.parseGradientColor(reader, composition, points);
                                continue block27;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block26;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block26;
                }
                case "t": {
                    gradientType = reader.nextInt() == 1 ? GradientType.Linear : GradientType.Radial;
                    continue block26;
                }
                case "s": {
                    startPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block26;
                }
                case "e": {
                    endPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block26;
                }
                case "r": {
                    fillType = reader.nextInt() == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
                    continue block26;
                }
            }
            reader.skipValue();
        }
        return new GradientFill(name, gradientType, fillType, color, opacity, startPoint, endPoint, null, null);
    }
}

