/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieValueCallback;

public class ImageLayer
extends BaseLayer {
    private final Paint paint = new Paint(3);
    private final Rect src = new Rect();
    private final Rect dst = new Rect();
    @Nullable
    private BaseKeyframeAnimation<ColorFilter, ColorFilter> colorFilterAnimation;

    ImageLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
    }

    @Override
    public void drawLayer(@NonNull Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null) {
            return;
        }
        float density = Utils.dpScale();
        this.paint.setAlpha(parentAlpha);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter(this.colorFilterAnimation.getValue());
        }
        canvas.save();
        canvas.concat(parentMatrix);
        this.src.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.dst.set(0, 0, (int)((float)bitmap.getWidth() * density), (int)((float)bitmap.getHeight() * density));
        canvas.drawBitmap(bitmap, this.src, this.dst, this.paint);
        canvas.restore();
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            outBounds.set(outBounds.left, outBounds.top, Math.min(outBounds.right, (float)bitmap.getWidth()), Math.min(outBounds.bottom, (float)bitmap.getHeight()));
            this.boundsMatrix.mapRect(outBounds);
        }
    }

    @Nullable
    private Bitmap getBitmap() {
        String refId = this.layerModel.getRefId();
        return this.lottieDrawable.getImageAsset(refId);
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.COLOR_FILTER) {
            this.colorFilterAnimation = callback == null ? null : new ValueCallbackKeyframeAnimation<ColorFilter, T>(callback);
        }
    }
}

