/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.value.LottieFrameInfo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LottieValueCallback<T> {
    private final LottieFrameInfo<T> frameInfo = new LottieFrameInfo();
    @Nullable
    BaseKeyframeAnimation<?, ?> animation;
    @Nullable
    protected T value = null;

    public LottieValueCallback() {
    }

    public LottieValueCallback(@NonNull T staticValue) {
        this.value = staticValue;
    }

    public T getValue(LottieFrameInfo<T> frameInfo) {
        if (this.value == null) {
            throw new IllegalArgumentException("You must provide a static value in the constructor , call setValue, or override getValue.");
        }
        return this.value;
    }

    public final void setValue(@Nullable T value) {
        if (this.animation != null) {
            this.value = value;
            this.animation.notifyListeners();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final T getValueInternal(float startFrame, float endFrame, T startValue, T endValue, float linearKeyframeProgress, float interpolatedKeyframeProgress, float overallProgress) {
        return this.getValue(this.frameInfo.set(startFrame, endFrame, startValue, endValue, linearKeyframeProgress, interpolatedKeyframeProgress, overallProgress));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setAnimation(@Nullable BaseKeyframeAnimation<?, ?> animation) {
        this.animation = animation;
    }
}

