/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.parser.KeyframeParser;
import com.airbnb.lottie.parser.ValueParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class KeyframesParser {
    private KeyframesParser() {
    }

    static <T> List<Keyframe<T>> parse(JsonReader reader, LottieComposition composition, float scale, ValueParser<T> valueParser) throws IOException {
        ArrayList<Keyframe<T>> keyframes = new ArrayList<Keyframe<T>>();
        if (reader.peek() == JsonToken.STRING) {
            composition.addWarning("Lottie doesn't support expressions.");
            return keyframes;
        }
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "k": {
                    if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                        reader.beginArray();
                        if (reader.peek() == JsonToken.NUMBER) {
                            keyframes.add(KeyframeParser.parse(reader, composition, scale, valueParser, false));
                        } else {
                            while (reader.hasNext()) {
                                keyframes.add(KeyframeParser.parse(reader, composition, scale, valueParser, true));
                            }
                        }
                        reader.endArray();
                        continue block6;
                    }
                    keyframes.add(KeyframeParser.parse(reader, composition, scale, valueParser, false));
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        KeyframesParser.setEndFrames(keyframes);
        return keyframes;
    }

    public static void setEndFrames(List<? extends Keyframe<?>> keyframes) {
        int size = keyframes.size();
        for (int i = 0; i < size - 1; ++i) {
            keyframes.get((int)i).endFrame = Float.valueOf(keyframes.get((int)(i + 1)).startFrame);
        }
        Keyframe<?> lastKeyframe = keyframes.get(size - 1);
        if (lastKeyframe.startValue == null) {
            keyframes.remove(lastKeyframe);
        }
    }
}

