/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableShapeValue;
import com.airbnb.lottie.model.animatable.AnimatableTextFrame;
import com.airbnb.lottie.parser.ColorParser;
import com.airbnb.lottie.parser.DocumentDataParser;
import com.airbnb.lottie.parser.FloatParser;
import com.airbnb.lottie.parser.GradientColorParser;
import com.airbnb.lottie.parser.IntegerParser;
import com.airbnb.lottie.parser.KeyframesParser;
import com.airbnb.lottie.parser.PointFParser;
import com.airbnb.lottie.parser.ScaleXYParser;
import com.airbnb.lottie.parser.ShapeDataParser;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.List;

public class AnimatableValueParser {
    private AnimatableValueParser() {
    }

    public static AnimatableFloatValue parseFloat(JsonReader reader, LottieComposition composition) throws IOException {
        return AnimatableValueParser.parseFloat(reader, composition, true);
    }

    public static AnimatableFloatValue parseFloat(JsonReader reader, LottieComposition composition, boolean isDp) throws IOException {
        return new AnimatableFloatValue(AnimatableValueParser.parse(reader, isDp ? Utils.dpScale() : 1.0f, composition, FloatParser.INSTANCE));
    }

    static AnimatableIntegerValue parseInteger(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatableIntegerValue(AnimatableValueParser.parse(reader, composition, IntegerParser.INSTANCE));
    }

    static AnimatablePointValue parsePoint(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatablePointValue(AnimatableValueParser.parse(reader, Utils.dpScale(), composition, PointFParser.INSTANCE));
    }

    static AnimatableScaleValue parseScale(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatableScaleValue(AnimatableValueParser.parse(reader, composition, ScaleXYParser.INSTANCE));
    }

    static AnimatableShapeValue parseShapeData(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatableShapeValue(AnimatableValueParser.parse(reader, Utils.dpScale(), composition, ShapeDataParser.INSTANCE));
    }

    static AnimatableTextFrame parseDocumentData(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatableTextFrame(AnimatableValueParser.parse(reader, composition, DocumentDataParser.INSTANCE));
    }

    static AnimatableColorValue parseColor(JsonReader reader, LottieComposition composition) throws IOException {
        return new AnimatableColorValue(AnimatableValueParser.parse(reader, composition, ColorParser.INSTANCE));
    }

    static AnimatableGradientColorValue parseGradientColor(JsonReader reader, LottieComposition composition, int points) throws IOException {
        return new AnimatableGradientColorValue(AnimatableValueParser.parse(reader, composition, new GradientColorParser(points)));
    }

    @Nullable
    private static <T> List<Keyframe<T>> parse(JsonReader reader, LottieComposition composition, ValueParser<T> valueParser) throws IOException {
        return KeyframesParser.parse(reader, composition, 1.0f, valueParser);
    }

    @Nullable
    private static <T> List<Keyframe<T>> parse(JsonReader reader, float scale, LottieComposition composition, ValueParser<T> valueParser) throws IOException {
        return KeyframesParser.parse(reader, composition, scale, valueParser);
    }
}

