/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.tts;

import cn.xfyun.model.response.TtsResponse;
import cn.xfyun.util.StringUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTtsWebSocketListener
extends WebSocketListener {
    public static final Gson JSON = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(AbstractTtsWebSocketListener.class);
    private static final int END = 2;
    private byte[] bytes = new byte[0];
    private File f;
    private FileOutputStream os;

    public AbstractTtsWebSocketListener() {
    }

    public AbstractTtsWebSocketListener(File f) throws FileNotFoundException {
        this.f = f;
        this.os = new FileOutputStream(f);
    }

    public abstract void onSuccess(byte[] var1);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);

    public abstract void onBusinessFail(WebSocket var1, TtsResponse var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        try {
            logger.debug("Handshake success, code={}, headers={}", (Object)response.code(), (Object)response.headers());
        }
        finally {
            try {
                response.close();
            }
            catch (Exception closeError) {
                logger.warn("response close failed", (Throwable)closeError);
            }
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        logger.debug("receive=>" + text);
        TtsResponse resp = (TtsResponse)JSON.fromJson(text, TtsResponse.class);
        if (resp != null) {
            if (resp.getCode() != 0) {
                logger.error("error=>" + resp.getMessage() + " sid=" + resp.getSid());
                this.onBusinessFail(webSocket, resp);
            }
            if (resp.getData() != null) {
                String result = resp.getData().getAudio();
                if (result != null) {
                    byte[] audio = Base64.getDecoder().decode(result);
                    this.bytes = StringUtils.unitByteArray((byte[])this.bytes, (byte[])audio);
                }
                if (resp.getData().getStatus() == 2) {
                    this.onSuccess(this.bytes);
                    if (this.f != null) {
                        try {
                            this.os.write(this.bytes);
                            this.os.flush();
                        }
                        catch (IOException e) {
                            logger.error("\u6587\u4ef6\u5199\u5165\u5931\u8d25", (Throwable)e);
                        }
                        logger.info("session end ");
                        logger.info("\u5408\u6210\u7684\u97f3\u9891\u6587\u4ef6\u4fdd\u5b58\u5728\uff1a" + this.f.getPath());
                    }
                    webSocket.close(1000, "");
                    try {
                        if (this.os != null) {
                            this.os.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error("\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                        this.onBusinessFail(webSocket, new TtsResponse(-1, "IO Exception", null, null));
                    }
                }
            }
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        logger.info("socket closing");
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.info("socket closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        super.onFailure(webSocket, t, response);
        try {
            this.onFail(webSocket, t, response);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception closeError) {
                    logger.warn("response close failed", (Throwable)closeError);
                }
            }
        }
    }
}

