/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.lfasr;

import cn.xfyun.model.response.lfasr.LfasrResponse;
import cn.xfyun.model.sign.LfasrSignature;
import cn.xfyun.util.FileUtil;
import cn.xfyun.util.HttpConnector;
import cn.xfyun.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfasrService {
    private static final Logger logger = LoggerFactory.getLogger(LfasrService.class);
    private static final String UPLOAD_URL = "https://raasr.xfyun.cn/v2/api/upload";
    private static final String GET_RESULT_URL = "https://raasr.xfyun.cn/v2/api/getResult";
    private final HttpConnector connector;
    private final Map<String, String> signatureParam = new HashMap<String, String>();

    private LfasrService(HttpConnector connector, LfasrSignature signature) throws SignatureException {
        this.connector = connector;
        this.signatureParam.put("appId", signature.getId());
        this.signatureParam.put("signa", signature.getSigna());
        this.signatureParam.put("ts", signature.getTs());
    }

    public static LfasrService build(String appId, String secretKey, int maxConnections, int connTimeout, int soTimeout, String proxyUrl) throws SignatureException {
        HttpConnector connector = HttpConnector.build((int)maxConnections, (int)connTimeout, (int)soTimeout, (int)3, (String)proxyUrl);
        LfasrSignature signature = new LfasrSignature(appId, secretKey);
        return new LfasrService(connector, signature);
    }

    public LfasrResponse uploadFile(Map<String, String> param, File audioFile) {
        param.putAll(this.signatureParam);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/octet-stream");
        header.put("Chunked", "false");
        try {
            URIBuilder uriBuilder = new URIBuilder(UPLOAD_URL);
            for (Map.Entry<String, String> entry : param.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            String finalUrl = uriBuilder.build().toString();
            byte[] audioData = FileUtil.readFileToByteArray((File)audioFile);
            String response = this.connector.postByBytes(finalUrl, header, audioData);
            return (LfasrResponse)StringUtils.gson.fromJson(response, LfasrResponse.class);
        }
        catch (IOException e) {
            logger.error("\u97f3\u9891\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return LfasrResponse.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            logger.error("\u6784\u5efaURL\u5931\u8d25", (Throwable)e);
            return LfasrResponse.error("\u6784\u5efa\u8bf7\u6c42URL\u5931\u8d25" + e.getMessage());
        }
    }

    public LfasrResponse uploadUrl(Map<String, String> param) {
        param.putAll(this.signatureParam);
        try {
            String response = this.connector.post(UPLOAD_URL, param);
            return (LfasrResponse)StringUtils.gson.fromJson(response, LfasrResponse.class);
        }
        catch (IOException e) {
            logger.error("\u97f3\u9891URL\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return LfasrResponse.error("URL\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
        }
    }

    public LfasrResponse getResult(String orderId, String resultType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderId", orderId);
        if (!StringUtils.isNullOrEmpty((String)resultType)) {
            param.put("resultType", resultType);
        }
        param.putAll(this.signatureParam);
        try {
            String response = this.connector.post(GET_RESULT_URL, param);
            return (LfasrResponse)StringUtils.gson.fromJson(response, LfasrResponse.class);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u8f6c\u5199\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            return LfasrResponse.error("\u83b7\u53d6\u7ed3\u679c\u5931\u8d25: " + e.getMessage());
        }
    }
}

