/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.iat;

import cn.xfyun.model.response.iat.IatResponse;
import cn.xfyun.util.StringUtils;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIatWebSocketListener
extends WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIatWebSocketListener.class);

    public abstract void onSuccess(WebSocket var1, IatResponse var2);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        try {
            logger.debug("Handshake success, code={}, headers={}", (Object)response.code(), (Object)response.headers());
        }
        finally {
            try {
                response.close();
            }
            catch (Exception closeError) {
                logger.warn("response close failed", (Throwable)closeError);
            }
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        try {
            if (text != null) {
                IatResponse iatResponse = (IatResponse)StringUtils.gson.fromJson(text, IatResponse.class);
                if (iatResponse != null) {
                    this.onSuccess(webSocket, iatResponse);
                } else {
                    this.onSuccess(webSocket, new IatResponse(-1, "iat response error"));
                }
            }
        }
        catch (Exception e) {
            logger.error("parse text to object fail ,text is [{}]", (Object)text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        logger.warn("webSocket is closing ,code is {} , reason is [{}]", (Object)code, (Object)reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.warn("webSocket is closed ,code is {} , reason is [{}]", (Object)code, (Object)reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        super.onFailure(webSocket, t, response);
        try {
            this.onFail(webSocket, t, response);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception closeError) {
                    logger.warn("response close failed", (Throwable)closeError);
                }
            }
        }
    }
}

