/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.exception.LfasrException;
import cn.xfyun.model.response.lfasr.LfasrResponse;
import cn.xfyun.service.lfasr.LfasrService;
import cn.xfyun.util.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;

public class LfasrClient {
    private volatile LfasrService lfasrService;
    private static final int FILE_UPLOAD_MAXSIZE = 524288000;
    private final String appId;
    private final String secretKey;
    private String fileName;
    private Long fileSize;
    private final Long duration;
    private final String language;
    private final String callbackUrl;
    private final String hotWord;
    private final Short candidate;
    private final Short roleType;
    private final Short roleNum;
    private final String pd;
    private String audioMode;
    private String audioUrl;
    private final Integer standardWav;
    private final Integer languageType;
    private final Short trackMode;
    private final String transLanguage;
    private final Short transMode;
    private final Integer engSegMax;
    private final Integer engSegMin;
    private final Float engSegWeight;
    private final Boolean engSmoothproc;
    private final Boolean engColloqproc;
    private final Integer engVadMdn;
    private final Integer engVadMargin;
    private final Integer engRlang;

    public LfasrClient(Builder builder) {
        this.appId = builder.appId;
        this.secretKey = builder.secretKey;
        this.fileName = builder.fileName;
        this.fileSize = builder.fileSize;
        this.duration = builder.duration;
        this.language = builder.language;
        this.callbackUrl = builder.callbackUrl;
        this.hotWord = builder.hotWord;
        this.candidate = builder.candidate;
        this.roleType = builder.roleType;
        this.roleNum = builder.roleNum;
        this.pd = builder.pd;
        this.audioMode = builder.audioMode;
        this.audioUrl = builder.audioUrl;
        this.standardWav = builder.standardWav;
        this.languageType = builder.languageType;
        this.trackMode = builder.trackMode;
        this.transLanguage = builder.transLanguage;
        this.transMode = builder.transMode;
        this.engSegMax = builder.engSegMax;
        this.engSegMin = builder.engSegMin;
        this.engSegWeight = builder.engSegWeight;
        this.engSmoothproc = builder.engSmoothproc;
        this.engColloqproc = builder.engColloqproc;
        this.engVadMdn = builder.engVadMdn;
        this.engVadMargin = builder.engVadMargin;
        this.engRlang = builder.engRlang;
    }

    public LfasrResponse uploadFile(String audioFilePath) throws LfasrException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)audioFilePath)) {
            throw new LfasrException("\u97f3\u9891\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a\uff01");
        }
        File audioFile = new File(audioFilePath);
        if (!audioFile.exists()) {
            throw new LfasrException(audioFilePath + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (audioFile.length() > 524288000L) {
            throw new LfasrException(audioFilePath + " \u6587\u4ef6\u8fc7\u5927(500M)");
        }
        HashMap<String, String> param = new HashMap<String, String>(32);
        this.audioMode = "fileStream";
        this.paramHandler(param, audioFile);
        return this.lfasrService.uploadFile(param, audioFile);
    }

    public LfasrResponse uploadUrl(String audioUrl) throws LfasrException, SignatureException {
        if (StringUtils.isNullOrEmpty((String)audioUrl)) {
            throw new LfasrException("\u97f3\u9891\u94fe\u63a5\u4e3a\u7a7a");
        }
        this.audioMode = "urlLink";
        this.audioUrl = audioUrl;
        this.fileName = StringUtils.isNullOrEmpty((String)this.fileName) ? audioUrl.substring(audioUrl.lastIndexOf("/") + 1) : this.fileName;
        this.fileSize = this.fileSize != null ? this.fileSize : 1L;
        HashMap<String, String> param = new HashMap<String, String>(32);
        this.paramHandler(param, null);
        return this.lfasrService.uploadUrl(param);
    }

    public LfasrResponse getResult(String orderId) throws SignatureException {
        if (StringUtils.isNullOrEmpty((String)orderId)) {
            throw new LfasrException("orderId\u4e3a\u7a7a");
        }
        return this.getResult(orderId, null);
    }

    public LfasrResponse getResult(String orderId, String resultType) throws SignatureException {
        if (StringUtils.isNullOrEmpty((String)orderId)) {
            throw new LfasrException("orderId\u4e3a\u7a7a");
        }
        return this.lfasrService.getResult(orderId, resultType);
    }

    private void paramHandler(Map<String, String> param, File audioFile) {
        param.put("fileName", StringUtils.isNullOrEmpty((String)this.fileName) ? audioFile.getName() : this.fileName);
        param.put("fileSize", this.fileSize == null ? audioFile.length() + "" : this.fileSize + "");
        param.put("duration", this.duration == null ? "1" : this.duration + "");
        if ("urlLink".equals(this.audioMode)) {
            try {
                String encodedUrl = URLEncoder.encode(this.audioUrl, "UTF-8");
                param.put("audioUrl", encodedUrl);
            }
            catch (UnsupportedEncodingException e) {
                throw new LfasrException("URL\u7f16\u7801\u5931\u8d25: " + e.getMessage());
            }
            param.put("audioUrl", this.audioUrl);
        }
        if (!StringUtils.isNullOrEmpty((String)this.language)) {
            param.put("language", this.language);
        }
        if (!StringUtils.isNullOrEmpty((String)this.callbackUrl)) {
            param.put("callbackUrl", this.callbackUrl);
        }
        if (!StringUtils.isNullOrEmpty((String)this.hotWord)) {
            param.put("hot_word", this.hotWord);
        }
        if (this.candidate != null) {
            param.put("candidate", this.candidate + "");
        }
        if (this.roleType != null) {
            param.put("roleType", this.roleType + "");
        }
        if (this.roleNum != null) {
            param.put("roleNum", this.roleNum + "");
        }
        if (!StringUtils.isNullOrEmpty((String)this.pd)) {
            param.put("pd", this.pd);
        }
        if (!StringUtils.isNullOrEmpty((String)this.audioMode)) {
            param.put("audioMode", this.audioMode);
        }
        if (!StringUtils.isNullOrEmpty((String)this.audioUrl)) {
            param.put("audioUrl", this.audioUrl);
        }
        if (this.standardWav != null) {
            param.put("standardWav", this.standardWav + "");
        }
        if (this.languageType != null) {
            param.put("languageType", this.languageType + "");
        }
        if (this.trackMode != null) {
            param.put("trackMode", this.trackMode + "");
        }
        if (!StringUtils.isNullOrEmpty((String)this.transLanguage)) {
            param.put("transLanguage", this.transLanguage);
        }
        if (this.transMode != null) {
            param.put("transMode", this.transMode + "");
        }
        if (this.engSegMax != null) {
            param.put("eng_seg_max", this.engSegMax + "");
        }
        if (this.engSegMin != null) {
            param.put("eng_seg_min", this.engSegMin + "");
        }
        if (this.engSegWeight != null) {
            param.put("eng_seg_weight", this.engSegWeight + "");
        }
        if (this.engSmoothproc != null) {
            param.put("eng_smoothproc", Boolean.toString(this.engSmoothproc));
        }
        if (this.engColloqproc != null) {
            param.put("eng_colloqproc", Boolean.toString(this.engColloqproc));
        }
        if (this.engVadMdn != null) {
            param.put("eng_vad_mdn", this.engVadMdn + "");
        }
        if (this.engVadMargin != null) {
            param.put("eng_vad_margin", this.engVadMargin + "");
        }
        if (this.engRlang != null) {
            param.put("eng_rlang", this.engRlang + "");
        }
    }

    public static final class Builder {
        private final String appId;
        private final String secretKey;
        private Integer maxConnections = 50;
        private Integer connTimeout = 10000;
        private Integer soTimeout = 30000;
        private String proxyUrl;
        private String fileName;
        private Long fileSize;
        private Long duration;
        private String language;
        private String callbackUrl;
        private String hotWord;
        private Short candidate;
        private Short roleType;
        private Short roleNum;
        private String pd;
        private String audioMode;
        private String audioUrl;
        private Integer standardWav;
        private Integer languageType;
        private Short trackMode;
        private String transLanguage;
        private Short transMode;
        private Integer engSegMax;
        private Integer engSegMin;
        private Float engSegWeight;
        private Boolean engSmoothproc;
        private Boolean engColloqproc;
        private Integer engVadMdn;
        private Integer engVadMargin;
        private Integer engRlang;

        public Builder(String appId, String secretKey) {
            if (StringUtils.isNullOrEmpty((String)appId)) {
                throw new IllegalArgumentException("appId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNullOrEmpty((String)secretKey)) {
                throw new IllegalArgumentException("secretKey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.appId = appId;
            this.secretKey = secretKey;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connTimeout(Integer connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder soTimeout(Integer soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder hotWord(String hotWord) {
            this.hotWord = hotWord;
            return this;
        }

        public Builder candidate(Short candidate) {
            this.candidate = candidate;
            return this;
        }

        public Builder roleType(Short roleType) {
            this.roleType = roleType;
            return this;
        }

        public Builder roleNum(Short roleNum) {
            this.roleNum = roleNum;
            return this;
        }

        public Builder pd(String pd) {
            this.pd = pd;
            return this;
        }

        public Builder audioMode(String audioMode) {
            this.audioMode = audioMode;
            return this;
        }

        public Builder audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        public Builder standardWav(Integer standardWav) {
            this.standardWav = standardWav;
            return this;
        }

        public Builder languageType(Integer languageType) {
            this.languageType = languageType;
            return this;
        }

        public Builder trackMode(Short trackMode) {
            this.trackMode = trackMode;
            return this;
        }

        public Builder transLanguage(String transLanguage) {
            this.transLanguage = transLanguage;
            return this;
        }

        public Builder transMode(Short transMode) {
            this.transMode = transMode;
            return this;
        }

        public Builder engSegMax(Integer engSegMax) {
            this.engSegMax = engSegMax;
            return this;
        }

        public Builder engSegMin(Integer engSegMin) {
            this.engSegMin = engSegMin;
            return this;
        }

        public Builder engSegWeight(Float engSegWeight) {
            this.engSegWeight = engSegWeight;
            return this;
        }

        public Builder engSmoothproc(Boolean engSmoothproc) {
            this.engSmoothproc = engSmoothproc;
            return this;
        }

        public Builder engColloqproc(Boolean engColloqproc) {
            this.engColloqproc = engColloqproc;
            return this;
        }

        public Builder engVadMdn(Integer engVadMdn) {
            this.engVadMdn = engVadMdn;
            return this;
        }

        public Builder engVadMargin(Integer engVadMargin) {
            this.engVadMargin = engVadMargin;
            return this;
        }

        public Builder engRlang(Integer engRlang) {
            this.engRlang = engRlang;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public LfasrClient build() throws SignatureException {
            LfasrClient lfasrClient = new LfasrClient(this);
            if (lfasrClient.lfasrService != null) return lfasrClient;
            Class<LfasrClient> clazz = LfasrClient.class;
            synchronized (LfasrClient.class) {
                if (lfasrClient.lfasrService != null) return lfasrClient;
                lfasrClient.lfasrService = LfasrService.build(this.appId, this.secretKey, this.maxConnections, this.connTimeout, this.soTimeout, this.proxyUrl);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lfasrClient;
            }
        }
    }
}

