/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.oralchat.request;

import cn.xfyun.api.OralChatClient;
import cn.xfyun.model.oralchat.Avatar;
import com.google.gson.annotations.SerializedName;

public class OralChatRequest {
    private Header header;
    private Parameter parameter;
    private Payload payload;

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static class Payload {
        private Audio audio;

        public Payload() {
        }

        public Payload(OralChatClient client) {
            this.audio = new Audio(client);
        }

        public Audio getAudio() {
            return this.audio;
        }

        public void setAudio(Audio audio) {
            this.audio = audio;
        }

        public static class Audio {
            private Integer status;
            private String audio;
            private String encoding;
            @SerializedName(value="sample_rate")
            private Integer sampleRate;
            private Integer channels;
            @SerializedName(value="bit_depth")
            private Integer bitDepth;
            @SerializedName(value="frame_size")
            private Integer frameSize;

            public Audio() {
            }

            public Audio(OralChatClient client) {
                this.encoding = client.getEncodingIn();
                this.sampleRate = client.getSampleRateIn();
                this.channels = client.getChannelsIn();
                this.bitDepth = client.getBitDepthIn();
                this.frameSize = client.getFrameSize();
            }

            public Integer getStatus() {
                return this.status;
            }

            public void setStatus(Integer status) {
                this.status = status;
            }

            public String getAudio() {
                return this.audio;
            }

            public void setAudio(String audio) {
                this.audio = audio;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String encoding) {
                this.encoding = encoding;
            }

            public Integer getSampleRate() {
                return this.sampleRate;
            }

            public void setSampleRate(Integer sampleRate) {
                this.sampleRate = sampleRate;
            }

            public Integer getChannels() {
                return this.channels;
            }

            public void setChannels(Integer channels) {
                this.channels = channels;
            }

            public Integer getBitDepth() {
                return this.bitDepth;
            }

            public void setBitDepth(Integer bitDepth) {
                this.bitDepth = bitDepth;
            }

            public Integer getFrameSize() {
                return this.frameSize;
            }

            public void setFrameSize(Integer frameSize) {
                this.frameSize = frameSize;
            }
        }
    }

    public static class Parameter {
        private Iat iat;
        private Nlp nlp;
        private Tts tts;
        private Avatar avatar;

        public Parameter() {
        }

        public Parameter(OralChatClient client) {
            this.iat = new Iat(client);
            this.nlp = new Nlp(client);
            this.tts = new Tts(client);
        }

        public Iat getIat() {
            return this.iat;
        }

        public void setIat(Iat iat) {
            this.iat = iat;
        }

        public Nlp getNlp() {
            return this.nlp;
        }

        public void setNlp(Nlp nlp) {
            this.nlp = nlp;
        }

        public Tts getTts() {
            return this.tts;
        }

        public void setTts(Tts tts) {
            this.tts = tts;
        }

        public Avatar getAvatar() {
            return this.avatar;
        }

        public void setAvatar(Avatar avatar) {
            this.avatar = avatar;
        }

        public static class Tts {
            private String vcn;
            @SerializedName(value="res_id")
            private String resId;
            @SerializedName(value="res_gender")
            private String resGender;
            private Integer speed;
            private Integer volume;
            private Integer pitch;
            private InnerTts tts;

            public Tts() {
            }

            public Tts(OralChatClient client) {
                this.tts = new InnerTts(client);
            }

            public String getVcn() {
                return this.vcn;
            }

            public void setVcn(String vcn) {
                this.vcn = vcn;
            }

            public String getResId() {
                return this.resId;
            }

            public void setResId(String resId) {
                this.resId = resId;
            }

            public String getResGender() {
                return this.resGender;
            }

            public void setResGender(String resGender) {
                this.resGender = resGender;
            }

            public Integer getSpeed() {
                return this.speed;
            }

            public void setSpeed(Integer speed) {
                this.speed = speed;
            }

            public Integer getVolume() {
                return this.volume;
            }

            public void setVolume(Integer volume) {
                this.volume = volume;
            }

            public Integer getPitch() {
                return this.pitch;
            }

            public void setPitch(Integer pitch) {
                this.pitch = pitch;
            }

            public InnerTts getTts() {
                return this.tts;
            }

            public void setTts(InnerTts tts) {
                this.tts = tts;
            }

            public static class InnerTts {
                private String encoding;
                @SerializedName(value="sample_rate")
                private Integer sampleRate;
                private Integer channels;
                @SerializedName(value="bit_depth")
                private Integer bitDepth;
                @SerializedName(value="frame_size")
                private Integer frameSize;

                public InnerTts() {
                }

                public InnerTts(OralChatClient client) {
                    this.encoding = client.getEncodingOut();
                    this.sampleRate = client.getSampleRateOut();
                    this.channels = client.getChannelsOut();
                    this.bitDepth = client.getBitDepthOut();
                    this.frameSize = client.getFrameSize();
                }

                public String getEncoding() {
                    return this.encoding;
                }

                public void setEncoding(String encoding) {
                    this.encoding = encoding;
                }

                public Integer getSampleRate() {
                    return this.sampleRate;
                }

                public void setSampleRate(Integer sampleRate) {
                    this.sampleRate = sampleRate;
                }

                public Integer getChannels() {
                    return this.channels;
                }

                public void setChannels(Integer channels) {
                    this.channels = channels;
                }

                public Integer getBitDepth() {
                    return this.bitDepth;
                }

                public void setBitDepth(Integer bitDepth) {
                    this.bitDepth = bitDepth;
                }
            }
        }

        public static class Nlp {
            private InnerNlp nlp;
            @SerializedName(value="new_session")
            private String newSession;
            private String personal;
            private String prompt;

            public Nlp() {
            }

            public Nlp(OralChatClient client) {
                this.nlp = new InnerNlp(client);
            }

            public InnerNlp getNlp() {
                return this.nlp;
            }

            public void setNlp(InnerNlp nlp) {
                this.nlp = nlp;
            }

            public String getNewSession() {
                return this.newSession;
            }

            public void setNewSession(String newSession) {
                this.newSession = newSession;
            }

            public String getPersonal() {
                return this.personal;
            }

            public void setPersonal(String personal) {
                this.personal = personal;
            }

            public String getPrompt() {
                return this.prompt;
            }

            public void setPrompt(String prompt) {
                this.prompt = prompt;
            }

            public static class InnerNlp {
                private String encoding;
                private String compress;
                private String format;

                public InnerNlp() {
                }

                public InnerNlp(OralChatClient client) {
                    this.encoding = client.getTextEncoding();
                    this.compress = client.getTextCompress();
                    this.format = client.getTextFormat();
                }

                public String getEncoding() {
                    return this.encoding;
                }

                public void setEncoding(String encoding) {
                    this.encoding = encoding;
                }

                public String getCompress() {
                    return this.compress;
                }

                public void setCompress(String compress) {
                    this.compress = compress;
                }

                public String getFormat() {
                    return this.format;
                }

                public void setFormat(String format) {
                    this.format = format;
                }
            }
        }

        public static class Iat {
            private InnerIat iat;
            private Integer vgap;
            private String dwa;
            private String eos;
            private String domain;

            public Iat() {
            }

            public Iat(OralChatClient client) {
                this.iat = new InnerIat(client);
                this.vgap = client.getVgap();
                this.dwa = client.getDwa();
                this.eos = client.getEos();
                this.domain = client.getDomain();
            }

            public InnerIat getIat() {
                return this.iat;
            }

            public void setIat(InnerIat iat) {
                this.iat = iat;
            }

            public Integer getVgap() {
                return this.vgap;
            }

            public void setVgap(Integer vgap) {
                this.vgap = vgap;
            }

            public String getDwa() {
                return this.dwa;
            }

            public void setDwa(String dwa) {
                this.dwa = dwa;
            }

            public String getEos() {
                return this.eos;
            }

            public void setEos(String eos) {
                this.eos = eos;
            }

            public String getDomain() {
                return this.domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public static class InnerIat {
                private String encoding;
                private String compress;
                private String format;

                public InnerIat() {
                }

                public InnerIat(OralChatClient client) {
                    this.encoding = client.getTextEncoding();
                    this.compress = client.getTextCompress();
                    this.format = client.getTextFormat();
                }

                public String getEncoding() {
                    return this.encoding;
                }

                public void setEncoding(String encoding) {
                    this.encoding = encoding;
                }

                public String getCompress() {
                    return this.compress;
                }

                public void setCompress(String compress) {
                    this.compress = compress;
                }

                public String getFormat() {
                    return this.format;
                }

                public void setFormat(String format) {
                    this.format = format;
                }
            }
        }
    }

    public static class Header {
        @SerializedName(value="app_id")
        private String appId;
        private String uid;
        private Integer status;
        private String stmid;
        private String scene;
        @SerializedName(value="interact_mode")
        private String interactMode;
        @SerializedName(value="os_sys")
        private String osSys;
        @SerializedName(value="pers_param")
        private String persParam;

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getStmid() {
            return this.stmid;
        }

        public void setStmid(String stmid) {
            this.stmid = stmid;
        }

        public String getScene() {
            return this.scene;
        }

        public void setScene(String scene) {
            this.scene = scene;
        }

        public String getInteractMode() {
            return this.interactMode;
        }

        public void setInteractMode(String interactMode) {
            this.interactMode = interactMode;
        }

        public String getOsSys() {
            return this.osSys;
        }

        public void setOsSys(String osSys) {
            this.osSys = osSys;
        }

        public String getPersParam() {
            return this.persParam;
        }

        public void setPersParam(String persParam) {
            this.persParam = persParam;
        }
    }
}

