/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.VoiceTrainEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.VoiceCloneSignature;
import cn.xfyun.model.voiceclone.request.AudioAddParam;
import cn.xfyun.model.voiceclone.request.CreateTaskParam;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoiceTrainClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(VoiceTrainClient.class);
    private static final long TOKEN_AUTO_REFRESH_TIME = 1800L;
    private String token;
    private final String tokenUrl;
    private long tokenExpiryTime;

    public VoiceTrainClient(Builder builder) {
        super((HttpBuilder)builder);
        this.tokenUrl = builder.tokenUrl;
        this.refreshToken();
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setToken(String token, long expireTime) {
        this.token = token;
        this.tokenExpiryTime = System.currentTimeMillis() + expireTime;
    }

    public long getTokenExpiryTime() {
        return this.tokenExpiryTime;
    }

    public String refreshToken() {
        try {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String bodyStr = this.buildTokenParam(timestamp);
            String token = this.send(VoiceTrainEnum.TOKEN, bodyStr, timestamp, null);
            this.cacheToken(token);
            return token;
        }
        catch (Exception e) {
            logger.error("token\u5237\u65b0\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String trainText(Long textId) throws Exception {
        this.tokenCheck(textId);
        JsonObject body = new JsonObject();
        body.addProperty("textId", (Number)textId);
        String bodyStr = StringUtils.gson.toJson((JsonElement)body);
        return this.send(VoiceTrainEnum.TRAIN_TEXT, bodyStr, null, null);
    }

    public String createTask(CreateTaskParam param) throws Exception {
        this.tokenCheck(param);
        String bodyStr = param.toJsonString();
        return this.send(VoiceTrainEnum.TASK_ADD, bodyStr, null, null);
    }

    public String audioAdd(AudioAddParam param) throws Exception {
        this.tokenCheck(param);
        param.selfCheckUrl();
        String bodyStr = param.toJsonString();
        return this.send(VoiceTrainEnum.AUDIO_ADD, bodyStr, null, null);
    }

    public String submit(String taskId) throws Exception {
        this.tokenCheck(taskId);
        JsonObject body = new JsonObject();
        body.addProperty("taskId", taskId);
        String bodyStr = StringUtils.gson.toJson((JsonElement)body);
        return this.send(VoiceTrainEnum.TASK_SUBMIT, bodyStr, null, null);
    }

    public String submitWithAudio(AudioAddParam param) throws Exception {
        this.tokenCheck(param);
        param.selfCheckFile();
        RequestBody httpBody = this.getRequestBody(param);
        return this.send(VoiceTrainEnum.AUDIO_SUBMIT, httpBody.toString(), null, httpBody);
    }

    public String result(String taskId) throws Exception {
        this.tokenCheck(taskId);
        JsonObject body = new JsonObject();
        body.addProperty("taskId", taskId);
        String bodyStr = StringUtils.gson.toJson((JsonElement)body);
        return this.send(VoiceTrainEnum.TASK_RESULT, bodyStr, null, null);
    }

    private RequestBody getRequestBody(AudioAddParam request) {
        File file = request.getFile();
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file));
        builder.addFormDataPart("taskId", request.getTaskId());
        builder.addFormDataPart("textId", String.valueOf(request.getTextId()));
        builder.addFormDataPart("textSegId", String.valueOf(request.getTextSegId()));
        if (request.getDenoiseSwitch() != null) {
            builder.addFormDataPart("denoiseSwitch", String.valueOf(request.getDenoiseSwitch()));
        }
        if (request.getMosRatio() != null) {
            builder.addFormDataPart("mosRatio", String.valueOf(request.getMosRatio()));
        }
        return builder.build();
    }

    private String send(VoiceTrainEnum trainEnum, String bodyStr, String timestamp, RequestBody body) throws IOException {
        Map header;
        String url = this.hostUrl;
        if (trainEnum == VoiceTrainEnum.TOKEN) {
            header = VoiceCloneSignature.tokenSign((String)this.apiKey, (String)timestamp, (String)bodyStr);
            url = this.tokenUrl;
        } else {
            url = url + trainEnum.getUrl();
            header = VoiceCloneSignature.commonSign((String)this.appId, (String)this.apiKey, (String)bodyStr, (String)this.token);
        }
        logger.debug("{}\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{trainEnum.getDesc(), trainEnum.getUrl(), bodyStr});
        if (null != body) {
            return this.sendPost(url, header, body, null);
        }
        return this.sendPost(url, JSON, header, bodyStr);
    }

    private void tokenCheck(Object param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.token == null || System.currentTimeMillis() > this.tokenExpiryTime) {
            this.refreshToken();
        }
    }

    private void cacheToken(String token) {
        if (!StringUtils.isNullOrEmpty((String)token)) {
            JsonObject tokenObj = (JsonObject)StringUtils.gson.fromJson(token, JsonObject.class);
            this.token = tokenObj.get("accesstoken").getAsString();
            long expiresin = tokenObj.get("expiresin").getAsLong();
            if (expiresin > 1800L) {
                expiresin -= 1800L;
            }
            this.tokenExpiryTime = System.currentTimeMillis() + expiresin * 1000L;
        }
    }

    private String buildTokenParam(String timestamp) {
        JsonObject body = new JsonObject();
        body.addProperty("model", "remote");
        JsonObject base = new JsonObject();
        base.addProperty("appid", this.appId);
        base.addProperty("timestamp", timestamp);
        base.addProperty("version", "v1");
        body.add("base", (JsonElement)base);
        return StringUtils.gson.toJson((JsonElement)body);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "http://opentrain.xfyousheng.com/voice_train";
        private String tokenUrl = VoiceTrainEnum.TOKEN.getUrl();

        public Builder(String appId, String apiKey) {
            super(HOST_URL, appId, apiKey, null);
        }

        public Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public VoiceTrainClient build() {
            return new VoiceTrainClient(this);
        }
    }
}

