/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.config.VoiceCloneLangEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.voiceclone.request.VoiceCloneRequest;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Base64;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class VoiceCloneClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(VoiceCloneClient.class);
    private final String textEncoding;
    private final String textCompress;
    private final String textFormat;
    private final String resId;
    private final int languageId;
    private final int speed;
    private final int volume;
    private final int pitch;
    private final int bgs;
    private final int reg;
    private final int rdn;
    private final int rhy;
    private final String encoding;
    private final int sampleRate;
    private final String vcn;
    private final int status;

    public VoiceCloneClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.textEncoding = builder.textEncoding;
        this.textCompress = builder.textCompress;
        this.textFormat = builder.textFormat;
        this.resId = builder.resId;
        this.languageId = builder.languageId;
        this.speed = builder.speed;
        this.volume = builder.volume;
        this.pitch = builder.pitch;
        this.bgs = builder.bgs;
        this.reg = builder.reg;
        this.rdn = builder.rdn;
        this.rhy = builder.rhy;
        this.encoding = builder.encoding;
        this.sampleRate = builder.sampleRate;
        this.vcn = builder.vcn;
        this.status = builder.status;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public String getTextCompress() {
        return this.textCompress;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public String getVcn() {
        return this.vcn;
    }

    public int getStatus() {
        return this.status;
    }

    public String getResId() {
        return this.resId;
    }

    public int getLanguageId() {
        return this.languageId;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getBgs() {
        return this.bgs;
    }

    public int getReg() {
        return this.reg;
    }

    public int getRdn() {
        return this.rdn;
    }

    public int getRhy() {
        return this.rhy;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void send(String text, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(text);
        WebSocket socket = this.newWebSocket(webSocketListener);
        try {
            String param = this.buildParam(text);
            logger.debug("\u4e00\u53e5\u8bdd\u590d\u523b\u5408\u6210\u5165\u53c2\uff1a{}", (Object)param);
            socket.send(param);
        }
        catch (Exception e) {
            logger.error("\u4e00\u53e5\u8bdd\u590d\u523b\u5408\u6210\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
    }

    private void paramCheck(String text) {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("\u5408\u6210\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 8000) {
            throw new BusinessException("\u5408\u6210\u6587\u672c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc78000\u5b57\u8282");
        }
    }

    private String buildParam(String text) {
        VoiceCloneRequest request = new VoiceCloneRequest();
        VoiceCloneRequest.Header header = new VoiceCloneRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        header.setResId(this.resId);
        request.setHeader(header);
        VoiceCloneRequest.Parameter parameter = new VoiceCloneRequest.Parameter(this);
        parameter.getTts().setVcn(this.vcn);
        parameter.getTts().setPybuffer(1);
        request.setParameter(parameter);
        VoiceCloneRequest.Payload payload = new VoiceCloneRequest.Payload();
        VoiceCloneRequest.Payload.Text payloadText = new VoiceCloneRequest.Payload.Text();
        payloadText.setEncoding(this.textEncoding);
        payloadText.setCompress(this.textCompress);
        payloadText.setFormat(this.textFormat);
        payloadText.setStatus(this.status);
        payloadText.setSeq(0);
        payloadText.setText(Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
        payload.setText(payloadText);
        request.setPayload(payload);
        return StringUtils.gson.toJson((Object)request);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "http://cn-huabei-1.xf-yun.com/v1/private/voice_clone";
        private String textEncoding = "utf8";
        private String textCompress = "raw";
        private String textFormat = "plain";
        private String resId;
        private int languageId = 0;
        private int speed = 50;
        private int volume = 50;
        private int pitch = 50;
        private int bgs = 0;
        private int reg = 0;
        private int rdn = 0;
        private int rhy = 0;
        private String encoding = "lame";
        private int sampleRate = 24000;
        private int status = 2;
        private String vcn = "x5_clone";

        public VoiceCloneClient build() {
            return new VoiceCloneClient(this);
        }

        public Builder signature(String resId, VoiceCloneLangEnum langEnum, String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            this.resId = resId;
            this.languageId = langEnum.code();
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder textEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
            return this;
        }

        public Builder textCompress(String textCompress) {
            this.textCompress = textCompress;
            return this;
        }

        public Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public Builder speed(int speed) {
            this.speed = speed;
            return this;
        }

        public Builder volume(int volume) {
            this.volume = volume;
            return this;
        }

        public Builder pitch(int pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder bgs(int bgs) {
            this.bgs = bgs;
            return this;
        }

        public Builder reg(int reg) {
            this.reg = reg;
            return this;
        }

        public Builder rdn(int rdn) {
            this.rdn = rdn;
            return this;
        }

        public Builder rhy(int rhy) {
            this.rhy = rhy;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder vcn(String vcn) {
            this.vcn = vcn;
            return this;
        }
    }
}

