/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.config.SparkIatModelEnum;
import cn.xfyun.model.sparkiat.request.SparkIatRequest;
import cn.xfyun.service.common.AbstractTask;
import cn.xfyun.service.sparkiat.SparkIatSendTask;
import cn.xfyun.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIatClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SparkIatClient.class);
    private static final String CN_LANGUAGE_API = "https://iat.xf-yun.com/v1";
    private static final String MULTI_LANGUAGE_API = "https://iat.cn-huabei-1.xf-yun.com/v1";
    private final ExecutorService executor;
    private final Integer langType;
    private final String language;
    private final String domain;
    private final String accent;
    private final int eos;
    private final int vinfo;
    private final String dwa;
    private final Integer nbest;
    private final Integer wbest;
    private final Integer ptt;
    private final Integer smth;
    private final Integer nunum;
    private final Integer opt;
    private final String dhw;
    private final String rlang;
    private final Integer ltc;
    private final String encoding;
    private final Integer sampleRate;
    private final Integer channels;
    private final Integer bitDepth;
    private final Integer frameSize;
    private final String textEncoding;
    private final String textCompress;
    private final String textFormat;
    private final String ln;

    public SparkIatClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.executor = null == builder.executor ? Executors.newSingleThreadExecutor() : builder.executor;
        this.language = builder.language;
        this.domain = "slm";
        this.accent = builder.accent;
        this.eos = builder.eos;
        this.encoding = builder.encoding;
        this.dwa = builder.dwa;
        this.smth = builder.smth;
        this.ptt = builder.ptt;
        this.rlang = builder.rlang;
        this.vinfo = builder.vinfo;
        this.nunum = builder.nunum;
        this.dhw = builder.dhw;
        this.opt = builder.opt;
        this.ltc = builder.ltc;
        this.sampleRate = builder.sampleRate;
        this.channels = builder.channels;
        this.bitDepth = builder.bitDepth;
        this.nbest = builder.nbest;
        this.wbest = builder.wbest;
        this.frameSize = builder.frameSize;
        this.textEncoding = builder.textEncoding;
        this.textCompress = builder.textCompress;
        this.textFormat = builder.textFormat;
        this.langType = builder.langType;
        this.ln = builder.ln;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAccent() {
        return this.accent;
    }

    public int getEos() {
        return this.eos;
    }

    public int getVinfo() {
        return this.vinfo;
    }

    public String getDwa() {
        return this.dwa;
    }

    public Integer getNbest() {
        return this.nbest;
    }

    public Integer getWbest() {
        return this.wbest;
    }

    public Integer getPtt() {
        return this.ptt;
    }

    public Integer getSmth() {
        return this.smth;
    }

    public Integer getNunum() {
        return this.nunum;
    }

    public Integer getOpt() {
        return this.opt;
    }

    public String getDhw() {
        return this.dhw;
    }

    public String getRlang() {
        return this.rlang;
    }

    public Integer getLtc() {
        return this.ltc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public Integer getBitDepth() {
        return this.bitDepth;
    }

    public Integer getFrameSize() {
        return this.frameSize;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public String getTextCompress() {
        return this.textCompress;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public Integer getLangType() {
        return this.langType;
    }

    public String getLn() {
        return this.ln;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public WebSocket start(WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        return this.newWebSocket(webSocketListener);
    }

    public void sendMessage(WebSocket webSocket, byte[] bytes, Integer status, Integer seq) {
        SparkIatRequest request = new SparkIatRequest();
        SparkIatRequest.Header header = new SparkIatRequest.Header(this.appId, status);
        request.setHeader(header);
        if (0 == status) {
            SparkIatRequest.Parameter parameter = new SparkIatRequest.Parameter(this);
            request.setParameter(parameter);
        }
        SparkIatRequest.Payload payload = new SparkIatRequest.Payload(this);
        if (bytes == null || bytes.length == 0) {
            payload.getAudio().setAudio("");
        } else {
            payload.getAudio().setAudio(Base64.getEncoder().encodeToString(bytes));
        }
        payload.getAudio().setSeq(seq);
        payload.getAudio().setStatus(status);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("\u5927\u6a21\u578b\u8bed\u97f3\u542c\u5199\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)json);
        webSocket.send(json);
    }

    public void send(File file, WebSocketListener webSocketListener) throws FileNotFoundException, MalformedURLException, SignatureException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.send(fileInputStream, webSocketListener);
    }

    public void send(InputStream inputStream, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (inputStream == null) {
            return;
        }
        WebSocket socket = this.newWebSocket(webSocketListener);
        logger.debug("\u8bed\u97f3\u542c\u5199\u8bf7\u6c42URL\uff1a{}", (Object)this.originHostUrl);
        SparkIatSendTask sparkIatSendTask = new SparkIatSendTask();
        new AbstractTask.Builder().inputStream(inputStream).webSocket(socket).client(this).build(sparkIatSendTask);
        this.executor.submit(sparkIatSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        WebSocket socket = this.newWebSocket(webSocketListener);
        logger.debug("\u8bed\u97f3\u542c\u5199\u8bf7\u6c42URL\uff1a{}", (Object)this.originHostUrl);
        SparkIatSendTask sparkIatSendTask = new SparkIatSendTask();
        new AbstractTask.Builder().bytes(bytes).webSocket(socket).client(this).closeable(closeable).build(sparkIatSendTask);
        this.executor.submit(sparkIatSendTask);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://iat.xf-yun.com/v1";
        private Integer langType = 1;
        private String language = "zh_cn";
        private final String domain = "slm";
        private String accent = "mandarin";
        private String encoding = "raw";
        private String dwa;
        private Integer smth;
        private Integer eos = 6000;
        private Integer ptt;
        private String rlang;
        private Integer nunum;
        private Integer nbest = 0;
        private Integer wbest = 0;
        private int vinfo = 1;
        private String dhw;
        private Integer opt;
        private Integer ltc;
        private Integer sampleRate = 16000;
        private Integer channels = 1;
        private Integer bitDepth = 16;
        private Integer frameSize = 1280;
        private String textEncoding = "utf8";
        private String textCompress = "raw";
        private String textFormat = "json";
        private String ln = "none";
        private ExecutorService executor;

        public SparkIatClient build() {
            return new SparkIatClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret, Integer langType) {
            super.signature(appId, apiKey, apiSecret);
            if (SparkIatModelEnum.ZH_CN_MULACC.codeEquals(langType)) {
                this.hostUrl = SparkIatClient.MULTI_LANGUAGE_API;
                this.accent = "mulacc";
                this.langType = langType;
            } else if (SparkIatModelEnum.MUL_CN_MANDARIN.codeEquals(langType)) {
                this.hostUrl = SparkIatClient.MULTI_LANGUAGE_API;
                this.language = "mul_cn";
                this.langType = langType;
            }
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder eos(int eos) {
            this.eos = eos;
            return this;
        }

        public Builder vinfo(int vinfo) {
            this.vinfo = vinfo;
            return this;
        }

        public Builder dwa(String dwa) {
            this.dwa = dwa;
            return this;
        }

        public Builder nbest(Integer nbest) {
            this.nbest = nbest;
            return this;
        }

        public Builder wbest(Integer wbest) {
            this.wbest = wbest;
            return this;
        }

        public Builder ptt(Integer ptt) {
            this.ptt = ptt;
            return this;
        }

        public Builder smth(Integer smth) {
            this.smth = smth;
            return this;
        }

        public Builder nunum(Integer nunum) {
            this.nunum = nunum;
            return this;
        }

        public Builder opt(Integer opt) {
            this.opt = opt;
            return this;
        }

        public Builder dhw(String dhw) {
            this.dhw = dhw;
            return this;
        }

        public Builder rlang(String rlang) {
            this.rlang = rlang;
            return this;
        }

        public Builder ltc(Integer ltc) {
            this.ltc = ltc;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder textEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
            return this;
        }

        public Builder textCompress(String textCompress) {
            this.textCompress = textCompress;
            return this;
        }

        public Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public Builder ln(String ln) {
            this.ln = ln;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }
    }
}

