/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sparkmodel.SparkChatParam;
import cn.xfyun.model.sparkmodel.request.SparkSendRequest;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.security.SignatureException;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkAssistantClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SparkAssistantClient.class);
    private final float temperature;
    private final int maxTokens;
    private final int topK;
    private final String domain;
    private final String assistantId;

    public SparkAssistantClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.assistantId = builder.assistantId;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
        this.topK = builder.topK;
        this.domain = builder.domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public void send(SparkChatParam sparkChatParam, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(sparkChatParam);
        WebSocket webSocket = this.newWebSocket(webSocketListener);
        try {
            String param = this.buildParam(sparkChatParam);
            logger.debug("\u56fe\u50cf\u7406\u89e3ws\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
            webSocket.send(param);
        }
        catch (Exception e) {
            logger.error("ws\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    private void paramCheck(SparkChatParam param) {
        if (param.getMessages() == null || param.getMessages().isEmpty()) {
            throw new BusinessException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(SparkChatParam param) {
        SparkSendRequest sendRequest = new SparkSendRequest();
        SparkSendRequest.Header header = new SparkSendRequest.Header(this.appId, param.getUserId());
        sendRequest.setHeader(header);
        SparkSendRequest.Parameter parameter = new SparkSendRequest.Parameter();
        SparkSendRequest.Parameter.Chat chat = new SparkSendRequest.Parameter.Chat();
        chat.setDomain(this.domain);
        chat.setTemperature(Float.valueOf(this.temperature));
        chat.setMaxTokens(this.maxTokens);
        chat.setTopK(this.topK);
        chat.setChatId(param.getChatId());
        parameter.setChat(chat);
        sendRequest.setParameter(parameter);
        SparkSendRequest.Payload payload = new SparkSendRequest.Payload();
        SparkSendRequest.Payload.Message message = new SparkSendRequest.Payload.Message();
        message.setText(param.getMessages());
        payload.setMessage(message);
        sendRequest.setPayload(payload);
        return StringUtils.gson.toJson((Object)sendRequest);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String assistantId;
        private String hostUrl = "https://spark-openapi.cn-huabei-1.xf-yun.com/v1/assistants/";
        private float temperature = 0.5f;
        private int maxTokens = 2048;
        private int topK = 4;
        private String domain = "generalv3";

        public SparkAssistantClient build() {
            return new SparkAssistantClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret, String assistantId) {
            super.signature(appId, apiKey, apiSecret);
            this.assistantId = assistantId;
            this.hostUrl = this.hostUrl + assistantId;
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder topK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }
    }
}

